/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.testing.ValidationAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.oracle.OracleConfig;
import java.math.RoundingMode;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.testng.annotations.Test;

public class TestOracleConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OracleConfig)ConfigAssertions.recordDefaults(OracleConfig.class)).setSynonymsEnabled(false).setRemarksReportingEnabled(false).setDefaultNumberScale(null).setNumberRoundingMode(RoundingMode.UNNECESSARY).setConnectionPoolEnabled(true).setConnectionPoolMinSize(1).setConnectionPoolMaxSize(30).setInactiveConnectionTimeout(new Duration(20.0, TimeUnit.MINUTES)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"oracle.synonyms.enabled", (Object)"true").put((Object)"oracle.remarks-reporting.enabled", (Object)"true").put((Object)"oracle.number.default-scale", (Object)"2").put((Object)"oracle.number.rounding-mode", (Object)"CEILING").put((Object)"oracle.connection-pool.enabled", (Object)"false").put((Object)"oracle.connection-pool.min-size", (Object)"10").put((Object)"oracle.connection-pool.max-size", (Object)"20").put((Object)"oracle.connection-pool.inactive-timeout", (Object)"30s").buildOrThrow();
        OracleConfig expected = new OracleConfig().setSynonymsEnabled(true).setRemarksReportingEnabled(true).setDefaultNumberScale(Integer.valueOf(2)).setNumberRoundingMode(RoundingMode.CEILING).setConnectionPoolEnabled(false).setConnectionPoolMinSize(10).setConnectionPoolMaxSize(20).setInactiveConnectionTimeout(new Duration(30.0, TimeUnit.SECONDS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testValidation() {
        ValidationAssertions.assertFailsValidation((Object)new OracleConfig().setDefaultNumberScale(Integer.valueOf(-1)), (String)"defaultNumberScale", (String)"must be greater than or equal to 0", Min.class);
        ValidationAssertions.assertFailsValidation((Object)new OracleConfig().setDefaultNumberScale(Integer.valueOf(39)), (String)"defaultNumberScale", (String)"must be less than or equal to 38", Max.class);
        ValidationAssertions.assertFailsValidation((Object)new OracleConfig().setConnectionPoolMinSize(-1), (String)"connectionPoolMinSize", (String)"must be greater than or equal to 0", Min.class);
        ValidationAssertions.assertFailsValidation((Object)new OracleConfig().setConnectionPoolMaxSize(0), (String)"connectionPoolMaxSize", (String)"must be greater than or equal to 1", Min.class);
    }
}

