/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import io.trino.plugin.jdbc.BaseJdbcConnectorSmokeTest;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public abstract class BaseOracleConnectorSmokeTest
extends BaseJdbcConnectorSmokeTest {
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        switch (connectorBehavior) {
            case SUPPORTS_CREATE_SCHEMA: {
                return false;
            }
            case SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS: {
                return false;
            }
        }
        return super.hasBehavior(connectorBehavior);
    }

    @Test
    public void testCommentColumn() {
        String tableName = "test_comment_column_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(a integer)");
        this.assertUpdate("COMMENT ON COLUMN " + tableName + ".a IS 'new comment'");
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue())).doesNotContain(new CharSequence[]{"COMMENT 'new comment'"});
        this.assertUpdate("DROP TABLE " + tableName);
    }
}

