/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.plugin.jdbc.BaseJdbcConnectorTest;
import io.trino.plugin.oracle.TestSynonym;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.BaseConnectorTest;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import io.trino.testing.assertions.Assert;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TestView;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.SkipException;
import org.testng.annotations.Test;

public abstract class BaseOracleConnectorTest
extends BaseJdbcConnectorTest {
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        switch (connectorBehavior) {
            case SUPPORTS_TOPN_PUSHDOWN: {
                return false;
            }
            case SUPPORTS_AGGREGATION_PUSHDOWN: 
            case SUPPORTS_AGGREGATION_PUSHDOWN_STDDEV: 
            case SUPPORTS_AGGREGATION_PUSHDOWN_VARIANCE: 
            case SUPPORTS_AGGREGATION_PUSHDOWN_COVARIANCE: 
            case SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT: {
                return true;
            }
            case SUPPORTS_JOIN_PUSHDOWN: {
                return true;
            }
            case SUPPORTS_JOIN_PUSHDOWN_WITH_DISTINCT_FROM: {
                return false;
            }
            case SUPPORTS_CREATE_SCHEMA: {
                return false;
            }
            case SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT: 
            case SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT: 
            case SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS: {
                return false;
            }
            case SUPPORTS_ADD_COLUMN_WITH_COMMENT: 
            case SUPPORTS_SET_COLUMN_TYPE: {
                return false;
            }
            case SUPPORTS_COMMENT_ON_TABLE: {
                return false;
            }
            case SUPPORTS_ARRAY: 
            case SUPPORTS_ROW_TYPE: {
                return false;
            }
        }
        return super.hasBehavior(connectorBehavior);
    }

    protected String dataMappingTableName(String trinoTypeName) {
        return "tmp_trino_" + System.nanoTime();
    }

    protected Optional<BaseConnectorTest.DataMappingTestSetup> filterDataMappingSmokeTestData(BaseConnectorTest.DataMappingTestSetup dataMappingTestSetup) {
        String typeName = dataMappingTestSetup.getTrinoTypeName();
        if (typeName.equals("date") && (dataMappingTestSetup.getSampleValueLiteral().equals("DATE '0001-01-01'") || dataMappingTestSetup.getSampleValueLiteral().equals("DATE '1582-10-04'") || dataMappingTestSetup.getSampleValueLiteral().equals("DATE '1582-10-05'") || dataMappingTestSetup.getSampleValueLiteral().equals("DATE '1582-10-14'"))) {
            return Optional.empty();
        }
        if (typeName.equals("time") || typeName.equals("time(6)") || typeName.equals("timestamp(6)") || typeName.equals("timestamp(6) with time zone")) {
            return Optional.of(dataMappingTestSetup.asUnsupported());
        }
        if (typeName.equals("boolean")) {
            return Optional.empty();
        }
        return Optional.of(dataMappingTestSetup);
    }

    protected TestTable createTableWithDefaultColumns() {
        return new TestTable(this.onRemoteDatabase(), "test_default_cols", "(col_required decimal(20,0) NOT NULL,col_nullable decimal(20,0),col_default decimal(20,0) DEFAULT 43,col_nonnull_default decimal(20,0) DEFAULT 42 NOT NULL ,col_required2 decimal(20,0) NOT NULL)");
    }

    protected TestTable createTableWithUnsupportedColumn() {
        return new TestTable(this.onRemoteDatabase(), "test_unsupported_col", "(one NUMBER(19), two NUMBER, three VARCHAR2(10 CHAR))");
    }

    @Test
    public void testShowColumns() {
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM orders");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "decimal(19,0)", "", ""}).row(new Object[]{"custkey", "decimal(19,0)", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "timestamp(0)", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "decimal(10,0)", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testCommentColumn() {
        String tableName = "test_comment_column_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(a integer)");
        this.assertUpdate("COMMENT ON COLUMN " + tableName + ".a IS 'new comment'");
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue())).doesNotContain(new CharSequence[]{"COMMENT 'new comment'"});
    }

    public void testCommentColumnName(String columnName) {
        throw new SkipException("The test is covered in TestOraclePoolRemarksReportingConnectorSmokeTest");
    }

    public void testCommentColumnSpecialCharacter(String comment) {
        Assertions.assertThatThrownBy(() -> super.testCommentColumnSpecialCharacter(comment)).hasMessageContaining("expected [%s] but found [null]".formatted(comment));
        throw new SkipException("The test is covered in TestOraclePoolRemarksReportingConnectorSmokeTest");
    }

    public void testInformationSchemaFiltering() {
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_name = 'orders' LIMIT 1", "SELECT 'orders' table_name");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE data_type = 'decimal(19,0)' AND table_name = 'customer' AND column_name = 'custkey' LIMIT 1", "SELECT 'customer' table_name");
    }

    protected boolean isColumnNameRejected(Exception exception, String columnName, boolean delimited) {
        return columnName.equals("a\"quote") && exception.getMessage().contains("ORA-03001: unimplemented feature");
    }

    @Test
    public void testDescribeTable() {
        MaterializedResult expectedColumns = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "decimal(19,0)", "", ""}).row(new Object[]{"custkey", "decimal(19,0)", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "timestamp(0)", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "decimal(10,0)", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
        MaterializedResult actualColumns = this.computeActual("DESCRIBE orders");
        Assert.assertEquals((Iterable)actualColumns, (Iterable)expectedColumns);
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE orders").getOnlyValue())).matches((CharSequence)"CREATE TABLE \\w+\\.\\w+\\.orders \\Q(\n   orderkey decimal(19, 0),\n   custkey decimal(19, 0),\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate timestamp(0),\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority decimal(10, 0),\n   comment varchar(79)\n)");
    }

    public void testCharVarcharComparison() {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_char_varchar", "(k, v) AS VALUES   (-1, CAST(NULL AS char(3))),    (3, CAST('x  ' AS char(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS varchar(2))", "VALUES (3, 'x  ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS varchar(4))", "VALUES (3, 'x  ')");
        }
    }

    public void testVarcharCharComparison() {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_varchar_char", "(k, v) AS VALUES   (-1, CAST(NULL AS varchar(3))),    (0, CAST('' AS varchar(3))),   (1, CAST(' ' AS varchar(3))),    (2, CAST('  ' AS varchar(3))),    (3, CAST('   ' AS varchar(3))),   (4, CAST('x' AS varchar(3))),   (5, CAST('x ' AS varchar(3))),   (6, CAST('x  ' AS varchar(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS char(2))", "VALUES (1, ' '), (2, '  '), (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS char(2))", "VALUES (4, 'x'), (5, 'x '), (6, 'x  ')");
        }
    }

    public void testAggregationWithUnsupportedResultType() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT array_agg(nationkey) FROM nation"))).skipResultsCorrectnessCheckForPushdown().isNotFullyPushedDown(new Class[]{AggregationNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT histogram(regionkey) FROM nation"))).isNotFullyPushedDown(new Class[]{AggregationNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT multimap_agg(regionkey, nationkey) FROM nation"))).isNotFullyPushedDown(new Class[]{AggregationNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT approx_set(nationkey) FROM nation"))).isNotFullyPushedDown(new Class[]{AggregationNode.class, ProjectNode.class});
    }

    protected TestTable createAggregationTestTable(String name, List<String> rows) {
        return new TestTable(this.onRemoteDatabase(), name, "(short_decimal number(9, 3), long_decimal number(30, 10), a_bigint number(19), t_double binary_double)", rows);
    }

    public void testDeleteWithLike() {
        Assertions.assertThatThrownBy(() -> super.testDeleteWithLike()).hasStackTraceContaining("TrinoException: This connector does not support modifying table rows");
    }

    @Test
    public void testViews() {
        try (TestView view = new TestView(this.onRemoteDatabase(), this.getUser() + ".test_view", "SELECT 'O' as status FROM dual");){
            this.assertQuery("SELECT status FROM " + view.getName(), "SELECT 'O'");
        }
    }

    @Test
    public void testSynonyms() {
        try (TestSynonym synonym = new TestSynonym(this.onRemoteDatabase(), this.getUser() + ".test_synonym", "FOR ORDERS");){
            this.assertQueryFails("SELECT orderkey FROM " + synonym.getName(), "line 1:22: Table 'oracle.*' does not exist");
        }
    }

    @Test
    public void testPredicatePushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name = 'ROMANIA'"))).matches("VALUES (CAST(3 AS DECIMAL(19,0)), CAST(19 AS DECIMAL(19,0)), CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name BETWEEN 'POLAND' AND 'RPA'"))).matches("VALUES (CAST(3 AS DECIMAL(19,0)), CAST(19 AS DECIMAL(19,0)), CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name = 'romania'"))).returnsEmptyResult().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey FROM orders WHERE orderdate = DATE '1992-09-29'"))).matches("VALUES CAST(1250 AS DECIMAL(19,0)), 34406, 38436, 57570").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM (SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey) WHERE regionkey = 3"))).matches("VALUES (CAST(3 AS decimal(19,0)), CAST(77 AS decimal(38,0)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey HAVING sum(nationkey) = 77"))).matches("VALUES (CAST(3 AS decimal(19,0)), CAST(77 AS decimal(38,0)))").isFullyPushedDown();
    }

    @Test
    public void testPredicatePushdownForNumerics() {
        this.predicatePushdownTest("DECIMAL(9, 3)", "123.321", "<=", "124");
        this.predicatePushdownTest("DECIMAL(9, 3)", "123.321", "<=", "123.321");
        this.predicatePushdownTest("DECIMAL(9, 3)", "123.321", "=", "123.321");
        this.predicatePushdownTest("DECIMAL(30, 10)", "123456789.987654321", "<=", "123456790");
        this.predicatePushdownTest("DECIMAL(30, 10)", "123456789.987654321", "<=", "123456789.987654321");
        this.predicatePushdownTest("DECIMAL(30, 10)", "123456789.987654321", "=", "123456789.987654321");
        this.predicatePushdownTest("FLOAT(63)", "123456789.987654321", "<=", "CAST(123456789.99 AS REAL)");
        this.predicatePushdownTest("FLOAT(63)", "123456789.987654321", "<=", "CAST(123456789.99 AS DOUBLE)");
        this.predicatePushdownTest("FLOAT(126)", "123456789.987654321", "<=", "CAST(123456789.99 AS REAL)");
        this.predicatePushdownTest("FLOAT(126)", "123456789.987654321", "<=", "CAST(123456789.99 AS DOUBLE)");
        this.predicatePushdownTest("BINARY_FLOAT", "5.0f", "=", "CAST(5.0 AS REAL)");
        this.predicatePushdownTest("BINARY_DOUBLE", "20.233", "=", "CAST(20.233 AS DOUBLE)");
        this.predicatePushdownTest("NUMBER(5,3)", "5.0", "=", "CAST(5.0 AS DECIMAL(5,3))");
    }

    @Test
    public void testPredicatePushdownForChars() {
        this.predicatePushdownTest("CHAR(1)", "'0'", "=", "'0'");
        this.predicatePushdownTest("CHAR(1)", "'0'", "<=", "'0'");
        this.predicatePushdownTest("CHAR(5)", "'0'", "=", "CHAR'0'");
        this.predicatePushdownTest("CHAR(7)", "'my_char'", "=", "CAST('my_char' AS CHAR(7))");
        this.predicatePushdownTest("NCHAR(7)", "'my_char'", "=", "CAST('my_char' AS CHAR(7))");
        this.predicatePushdownTest("VARCHAR2(7)", "'my_char'", "=", "CAST('my_char' AS VARCHAR(7))");
        this.predicatePushdownTest("NVARCHAR2(7)", "'my_char'", "=", "CAST('my_char' AS VARCHAR(7))");
        try (TestTable table = new TestTable(this.onRemoteDatabase(), this.getUser() + ".test_pdown_", "(c_clob CLOB, c_nclob NCLOB)", (List)ImmutableList.of((Object)"'my_clob', 'my_nclob'"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT c_clob FROM %s WHERE c_clob = VARCHAR 'my_clob'", table.getName())))).isNotFullyPushedDown(new Class[]{FilterNode.class});
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT c_nclob FROM %s WHERE c_nclob = VARCHAR 'my_nclob'", table.getName())))).isNotFullyPushedDown(new Class[]{FilterNode.class});
        }
    }

    @Test
    public void testTooLargeDomainCompactionThreshold() {
        this.assertQueryFails(Session.builder((Session)this.getSession()).setCatalogSessionProperty("oracle", "domain_compaction_threshold", "10000").build(), "SELECT * from nation", "Domain compaction threshold \\(10000\\) cannot exceed 1000");
    }

    public void testNativeQuerySimple() {
        this.assertQuery("SELECT * FROM TABLE(system.query(query => 'SELECT CAST(1 AS number(2, 1)) FROM DUAL'))", "VALUES 1");
    }

    public void testNativeQueryParameters() {
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query_simple", "SELECT * FROM TABLE(system.query(query => ?))").addPreparedStatement("my_query", "SELECT * FROM TABLE(system.query(query => format('SELECT %s FROM %s', ?, ?)))").build();
        this.assertQuery(session, "EXECUTE my_query_simple USING 'SELECT CAST(1 AS number(2, 1)) a FROM DUAL'", "VALUES 1");
        this.assertQuery(session, "EXECUTE my_query USING 'a', '(SELECT CAST(2 AS number(2, 1)) a FROM DUAL) t'", "VALUES 2");
    }

    public void testNativeQueryInsertStatementTableDoesNotExist() {
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "non_existent_table"));
        Assertions.assertThatThrownBy(() -> this.query("SELECT * FROM TABLE(system.query(query => 'INSERT INTO non_existent_table VALUES (1)'))")).hasMessageContaining("Query not supported: ResultSetMetaData not available for query: INSERT INTO non_existent_table VALUES (1)");
    }

    public void testNativeQueryIncorrectSyntax() {
        Assertions.assertThatThrownBy(() -> this.query("SELECT * FROM TABLE(system.query(query => 'some wrong syntax'))")).hasMessageContaining("Query not supported: ResultSetMetaData not available for query: some wrong syntax");
    }

    protected TestTable simpleTable() {
        return new TestTable(this.onRemoteDatabase(), String.format("%s.simple_table", this.getSession().getSchema().orElseThrow()), "(col decimal(2, 1))", (List)ImmutableList.of((Object)"1", (Object)"2"));
    }

    protected String errorMessageForInsertIntoNotNullColumn(String columnName) {
        return String.format("ORA-01400: cannot insert NULL into \\(.*\"%s\"\\)\n", columnName.toUpperCase(Locale.ENGLISH));
    }

    protected void verifyAddNotNullColumnToNonEmptyTableFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessage("ORA-01758: table must be empty to add mandatory (NOT NULL) column\n");
    }

    protected void verifyConcurrentAddColumnFailurePermissible(Exception e) {
        Assertions.assertThat((Throwable)e).hasMessage("ORA-14411: The DDL cannot be run concurrently with other DDLs\n");
    }

    protected OptionalInt maxSchemaNameLength() {
        return OptionalInt.of(30);
    }

    protected void verifySchemaNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessage("ORA-00972: identifier is too long\n");
    }

    protected OptionalInt maxTableNameLength() {
        return OptionalInt.of(30);
    }

    protected void verifyTableNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessage("ORA-00972: identifier is too long\n");
    }

    protected OptionalInt maxColumnNameLength() {
        return OptionalInt.of(30);
    }

    protected void verifyColumnNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessage("ORA-00972: identifier is too long\n");
    }

    private void predicatePushdownTest(String oracleType, String oracleLiteral, String operator, String filterLiteral) {
        String tableName = ("test_pdown_" + oracleType.replaceAll("[^a-zA-Z0-9]", "")).replaceFirst("^(.{18}).*", "$1__");
        try (TestTable table = new TestTable(this.onRemoteDatabase(), this.getUser() + "." + tableName, String.format("(c %s)", oracleType));){
            this.onRemoteDatabase().execute(String.format("INSERT INTO %s VALUES (%s)", table.getName(), oracleLiteral));
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM %s WHERE c %s %s", table.getName(), operator, filterLiteral)))).isFullyPushedDown();
        }
    }

    protected String getUser() {
        return "trino_test";
    }
}

