/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.reflect.Reflection;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.DefaultQueryBuilder;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.jdbc.mapping.DefaultIdentifierMapping;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.plugin.oracle.OracleClient;
import io.trino.plugin.oracle.OracleConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestOracleClient {
    private static final JdbcClient CLIENT = new OracleClient(new BaseJdbcConfig(), new OracleConfig(), session -> {
        throw new UnsupportedOperationException();
    }, (QueryBuilder)new DefaultQueryBuilder(RemoteQueryModifier.NONE), (IdentifierMapping)new DefaultIdentifierMapping(), RemoteQueryModifier.NONE);
    private static final ConnectorSession SESSION = TestingConnectorSession.SESSION;

    @Test(dataProvider="writeMappingsProvider")
    public void testTypedNullWriteMapping(Type type, String bindExpression, int nullJdbcType) throws SQLException {
        WriteMapping writeMapping = CLIENT.toWriteMapping(SESSION, type);
        Assertions.assertThat((Object)writeMapping.getWriteFunction()).isNotNull();
        WriteFunction writeFunction = writeMapping.getWriteFunction();
        Assertions.assertThat((String)writeFunction.getBindExpression()).isEqualTo(bindExpression);
        PreparedStatement statementProxy = (PreparedStatement)Reflection.newProxy(PreparedStatement.class, (proxy, method, args) -> {
            Assertions.assertThat((String)method.getName()).isEqualTo("setNull");
            Assertions.assertThat((int)args.length).isEqualTo(2);
            Assertions.assertThat((Object)args[0]).isEqualTo((Object)1325);
            ((ObjectAssert)Assertions.assertThat((Object)args[1]).describedAs("expected jdbc type for NULL value", new Object[0])).isEqualTo((Object)nullJdbcType);
            return null;
        });
        writeFunction.setNull(statementProxy, 1325);
    }

    @DataProvider
    public Object[][] writeMappingsProvider() {
        return new Object[][]{{BooleanType.BOOLEAN, "?", -6}, {TinyintType.TINYINT, "?", -6}, {SmallintType.SMALLINT, "?", 5}, {IntegerType.INTEGER, "?", 4}, {BigintType.BIGINT, "?", -5}, {RealType.REAL, "?", 7}, {DoubleType.DOUBLE, "?", 8}, {VarbinaryType.VARBINARY, "?", -3}, {CharType.createCharType((int)25), "?", -15}, {DecimalType.createDecimalType((int)16, (int)6), "?", 3}, {DecimalType.createDecimalType((int)36, (int)12), "?", 3}, {VarcharType.createUnboundedVarcharType(), "?", 12}, {VarcharType.createVarcharType((int)123), "?", 12}, {TimestampType.TIMESTAMP_SECONDS, "TO_DATE(?, 'SYYYY-MM-DD HH24:MI:SS')", 12}, {TimestampType.TIMESTAMP_MILLIS, "TO_TIMESTAMP(?, 'SYYYY-MM-DD HH24:MI:SS.FF')", 12}, {TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "?", -101}, {DateType.DATE, "TO_DATE(?, 'SYYYY-MM-DD')", 12}};
    }
}

