/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.plugin.oracle.BaseOracleConnectorTest;
import io.trino.plugin.oracle.OracleQueryRunner;
import io.trino.plugin.oracle.TestingOracleServer;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.SqlExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestOracleConnectorTest
extends BaseOracleConnectorTest {
    private TestingOracleServer oracleServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.oracleServer = new TestingOracleServer();
        return OracleQueryRunner.createOracleQueryRunner(this.oracleServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.builder().put((Object)"connection-url", (Object)this.oracleServer.getJdbcUrl()).put((Object)"connection-user", (Object)"trino_test").put((Object)"connection-password", (Object)"trino_test_password").put((Object)"oracle.connection-pool.enabled", (Object)"false").put((Object)"oracle.remarks-reporting.enabled", (Object)"false").buildOrThrow(), REQUIRED_TPCH_TABLES);
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() throws IOException {
        Closeables.closeAll((Closeable[])new Closeable[]{this.oracleServer});
        this.oracleServer = null;
    }

    @Test
    public void testNativeMultipleInClauses() {
        String longInClauses = IntStream.range(0, 10).mapToObj(value -> this.getLongInClause(value * 1000, 1000)).collect(Collectors.joining(" OR "));
        this.onRemoteDatabase().execute(String.format("SELECT count(*) FROM %s.orders WHERE %s", "trino_test", longInClauses));
    }

    private String getLongInClause(int start, int length) {
        String longValues = IntStream.range(start, start + length).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        return "orderkey IN (" + longValues + ")";
    }

    protected SqlExecutor onRemoteDatabase() {
        return this.oracleServer::execute;
    }
}

