/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.plugin.oracle.BaseOracleConnectorSmokeTest;
import io.trino.plugin.oracle.OracleQueryRunner;
import io.trino.plugin.oracle.TestingOracleServer;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.TestTable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestOraclePoolRemarksReportingConnectorSmokeTest
extends BaseOracleConnectorSmokeTest {
    private TestingOracleServer oracleServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.oracleServer = new TestingOracleServer();
        return OracleQueryRunner.createOracleQueryRunner(this.oracleServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.builder().put((Object)"connection-url", (Object)this.oracleServer.getJdbcUrl()).put((Object)"connection-user", (Object)"trino_test").put((Object)"connection-password", (Object)"trino_test_password").put((Object)"oracle.connection-pool.enabled", (Object)"true").put((Object)"oracle.remarks-reporting.enabled", (Object)"true").buildOrThrow(), REQUIRED_TPCH_TABLES);
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() throws IOException {
        Closeables.closeAll((Closeable[])new Closeable[]{this.oracleServer});
        this.oracleServer = null;
    }

    @Override
    @Test
    public void testCommentColumn() {
        String tableName = "test_comment_column_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(a integer)");
        this.assertUpdate("COMMENT ON COLUMN " + tableName + ".a IS 'new comment'");
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue())).contains(new CharSequence[]{"COMMENT 'new comment'"});
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test(dataProvider="testCommentDataProvider")
    public void testCommentColumnSpecialCharacter(String comment) {
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_column_", "(a integer)");){
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS " + TestOraclePoolRemarksReportingConnectorSmokeTest.varcharLiteral(comment));
            Assert.assertEquals((String)this.getColumnComment(table.getName(), "a"), (String)comment);
        }
    }

    @DataProvider
    public Object[][] testCommentDataProvider() {
        return new Object[][]{{"a;semicolon"}, {"an@at"}, {"a\"quote"}, {"an'apostrophe"}, {"a`backtick`"}, {"a/slash`"}, {"a\\backslash`"}, {"a?question"}, {"[square bracket]"}};
    }

    private static String varcharLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        return "'" + value.replace("'", "''") + "'";
    }

    @Test(dataProvider="testColumnNameDataProvider")
    public void testCommentColumnName(String columnName) {
        if (!TestOraclePoolRemarksReportingConnectorSmokeTest.requiresDelimiting(columnName)) {
            this.testCommentColumnName(columnName, false);
        }
        this.testCommentColumnName(columnName, true);
    }

    private void testCommentColumnName(String columnName, boolean delimited) {
        String nameInSql = TestOraclePoolRemarksReportingConnectorSmokeTest.toColumnNameInSql(columnName, delimited);
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_column", "(" + nameInSql + " integer)");){
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + "." + nameInSql + " IS 'test comment'");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), columnName.replace("'", "''").toLowerCase(Locale.ENGLISH))).isEqualTo("test comment");
        }
        catch (RuntimeException e) {
            if (Throwables.getStackTraceAsString((Throwable)e).contains("CREATE TABLE") && (columnName.equals("a\"quote") || columnName.equals("\"STATS_MIXED_QUOTED_UPPER\"") || columnName.equals("\"stats_mixed_quoted_lower\"") || columnName.equals("\"stats_mixed_QuoTeD_miXED\""))) {
                return;
            }
            throw e;
        }
    }

    @DataProvider
    public Object[][] testColumnNameDataProvider() {
        return new Object[][]{{"STATS_MIXED_UNQUOTED_UPPER"}, {"stats_mixed_unquoted_lower"}, {"stats_mixed_uNQuoTeD_miXED"}, {"\"STATS_MIXED_QUOTED_UPPER\""}, {"\"stats_mixed_quoted_lower\""}, {"\"stats_mixed_QuoTeD_miXED\""}, {"lowercase"}, {"UPPERCASE"}, {"MixedCase"}, {"an_underscore"}, {"a-hyphen-minus"}, {"a space"}, {"atrailingspace "}, {" aleadingspace"}, {"a.dot"}, {"a,comma"}, {"a:colon"}, {"a;semicolon"}, {"an@at"}, {"a\"quote"}, {"an'apostrophe"}, {"a`backtick`"}, {"a/slash`"}, {"a\\backslash`"}, {"adigit0"}, {"0startwithdigit"}};
    }

    private static String toColumnNameInSql(String columnName, boolean delimited) {
        Object nameInSql = columnName;
        if (delimited) {
            nameInSql = "\"" + columnName.replace("\"", "\"\"") + "\"";
        }
        return nameInSql;
    }

    private static boolean requiresDelimiting(String identifierName) {
        return !identifierName.matches("[a-zA-Z][a-zA-Z0-9_]*");
    }

    protected String getColumnComment(String tableName, String columnName) {
        MaterializedResult materializedResult = this.computeActual(String.format("SELECT comment FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s' AND column_name = '%s'", this.getSession().getSchema().orElseThrow(), tableName, columnName));
        return (String)materializedResult.getOnlyValue();
    }
}

