/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.base.Joiner;
import com.google.common.io.Files;
import io.airlift.log.Logger;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.RetryingConnectionFactory;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.StaticCredentialProvider;
import io.trino.testing.ResourcePresence;
import io.trino.testing.TestingConnectorSession;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.temporal.ChronoUnit;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import oracle.jdbc.OracleDriver;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.utility.MountableFile;

public class TestingOracleServer
implements Closeable {
    private static final Logger log = Logger.get(TestingOracleServer.class);
    private static final RetryPolicy<Object> CONTAINER_RETRY_POLICY = new RetryPolicy().withBackoff(1L, 5L, ChronoUnit.SECONDS).withMaxAttempts(5).onRetry(event -> log.warn("Container initialization failed on attempt %s, will retry. Exception: %s", new Object[]{event.getAttemptCount(), event.getLastFailure().getMessage()}));
    private static final String TEST_TABLESPACE = "trino_test";
    public static final String TEST_USER = "trino_test";
    public static final String TEST_SCHEMA = "trino_test";
    public static final String TEST_PASS = "trino_test_password";
    private final OracleContainer container = (OracleContainer)Failsafe.with((Policy[])new RetryPolicy[]{CONTAINER_RETRY_POLICY}).get(this::createContainer);

    private OracleContainer createContainer() {
        OracleContainer container = ((OracleContainer)((OracleContainer)((OracleContainer)new OracleContainer("gvenzl/oracle-xe:11.2.0.2-full").withCopyFileToContainer(MountableFile.forClasspathResource((String)"init.sql"), "/container-entrypoint-initdb.d/01-init.sql")).withCopyFileToContainer(MountableFile.forClasspathResource((String)"restart.sh"), "/container-entrypoint-initdb.d/02-restart.sh")).withCopyFileToContainer(MountableFile.forHostPath((Path)this.createConfigureScript()), "/container-entrypoint-initdb.d/03-create-users.sql")).usingSid();
        container.start();
        return container;
    }

    private Path createConfigureScript() {
        try {
            File tempFile = File.createTempFile("init-", ".sql");
            Files.write((byte[])Joiner.on((String)"\n").join((Object)String.format("CREATE TABLESPACE %s DATAFILE 'test_db.dat' SIZE 100M ONLINE;", "trino_test"), (Object)String.format("CREATE USER %s IDENTIFIED BY %s DEFAULT TABLESPACE %s;", "trino_test", TEST_PASS, "trino_test"), new Object[]{String.format("GRANT UNLIMITED TABLESPACE TO %s;", "trino_test"), String.format("GRANT CREATE SESSION TO %s;", "trino_test"), String.format("GRANT ALL PRIVILEGES TO %s;", "trino_test")}).getBytes(StandardCharsets.UTF_8), (File)tempFile);
            return tempFile.toPath();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getJdbcUrl() {
        return this.container.getJdbcUrl();
    }

    public void execute(String sql) {
        this.execute(sql, "trino_test", TEST_PASS);
    }

    public void execute(String sql, String user, String password) {
        try (Connection connection = this.getConnectionFactory(this.getJdbcUrl(), user, password).openConnection(TestingConnectorSession.SESSION);
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private ConnectionFactory getConnectionFactory(String connectionUrl, String username, String password) {
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory((Driver)new OracleDriver(), new BaseJdbcConfig().setConnectionUrl(connectionUrl), (CredentialProvider)StaticCredentialProvider.of((String)username, (String)password));
        return new RetryingConnectionFactory((ConnectionFactory)connectionFactory);
    }

    @Override
    public void close() {
        this.container.stop();
    }

    @ResourcePresence
    public boolean isRunning() {
        return this.container.getContainerId() != null;
    }
}

