/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.math.RoundingMode;
import java.util.List;
import javax.inject.Inject;

public class DecimalSessionSessionProperties
implements SessionPropertiesProvider {
    public static final String DECIMAL_MAPPING = "decimal_mapping";
    public static final String DECIMAL_DEFAULT_SCALE = "decimal_default_scale";
    public static final String DECIMAL_ROUNDING_MODE = "decimal_rounding_mode";
    private final List<PropertyMetadata<?>> properties;

    @Inject
    public DecimalSessionSessionProperties(DecimalConfig decimalConfig) {
        this.properties = ImmutableList.of((Object)PropertyMetadata.enumProperty((String)DECIMAL_MAPPING, (String)"Decimal mapping for unspecified and exceeding precision decimals. STRICT skips them. ALLOW_OVERFLOW requires setting proper decimal scale and rounding mode", DecimalConfig.DecimalMapping.class, (Enum)decimalConfig.getDecimalMapping(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)DECIMAL_DEFAULT_SCALE, (String)"Default decimal scale for mapping unspecified and exceeding precision decimals. Not used when decimal_mapping is set to STRICT", (Integer)decimalConfig.getDecimalDefaultScale(), (boolean)false), (Object)PropertyMetadata.enumProperty((String)DECIMAL_ROUNDING_MODE, (String)"Rounding mode for mapping unspecified and exceeding precision decimals. Not used when decimal_mapping is set to STRICT", RoundingMode.class, (Enum)decimalConfig.getDecimalRoundingMode(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.properties;
    }

    public static DecimalConfig.DecimalMapping getDecimalRounding(ConnectorSession session) {
        return (DecimalConfig.DecimalMapping)((Object)session.getProperty(DECIMAL_MAPPING, DecimalConfig.DecimalMapping.class));
    }

    public static int getDecimalDefaultScale(ConnectorSession session) {
        return (Integer)session.getProperty(DECIMAL_DEFAULT_SCALE, Integer.class);
    }

    public static RoundingMode getDecimalRoundingMode(ConnectorSession session) {
        return (RoundingMode)((Object)session.getProperty(DECIMAL_ROUNDING_MODE, RoundingMode.class));
    }
}

