/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.units.Duration;
import io.trino.plugin.jdbc.CachingJdbcClient;
import io.trino.plugin.jdbc.DefaultJdbcMetadata;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcMetadataFactory;
import io.trino.plugin.jdbc.JdbcTransactionHandle;
import io.trino.plugin.jdbc.SingletonIdentityCacheMapping;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class DefaultJdbcMetadataFactory
implements JdbcMetadataFactory {
    private final JdbcClient jdbcClient;
    private final boolean allowDropTable;

    @Inject
    public DefaultJdbcMetadataFactory(JdbcClient jdbcClient, JdbcMetadataConfig config) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        Objects.requireNonNull(config, "config is null");
        this.allowDropTable = config.isAllowDropTable();
    }

    @Override
    public JdbcMetadata create(JdbcTransactionHandle transaction) {
        return this.create(new CachingJdbcClient(this.jdbcClient, Set.of(), new SingletonIdentityCacheMapping(), new Duration(1.0, TimeUnit.DAYS), true, Integer.MAX_VALUE), this.allowDropTable);
    }

    protected JdbcMetadata create(JdbcClient transactionCachingJdbcClient, boolean allowDropTable) {
        return new DefaultJdbcMetadata(transactionCachingJdbcClient, allowDropTable);
    }
}

