/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class JdbcMetadataConfig {
    static final int MAX_ALLOWED_WRITE_BATCH_SIZE = 1000000;
    private boolean allowDropTable;
    private boolean joinPushdownEnabled;
    private boolean aggregationPushdownEnabled = true;
    private boolean topNPushdownEnabled = true;
    private int domainCompactionThreshold = 32;
    private int writeBatchSize = 1000;
    private boolean nonTransactionalInsert;

    public boolean isAllowDropTable() {
        return this.allowDropTable;
    }

    @Config(value="allow-drop-table")
    @ConfigDescription(value="Allow connector to drop tables")
    public JdbcMetadataConfig setAllowDropTable(boolean allowDropTable) {
        this.allowDropTable = allowDropTable;
        return this;
    }

    public boolean isJoinPushdownEnabled() {
        return this.joinPushdownEnabled;
    }

    @LegacyConfig(value={"experimental.join-pushdown.enabled"})
    @Config(value="join-pushdown.enabled")
    @ConfigDescription(value="Enable join pushdown")
    public JdbcMetadataConfig setJoinPushdownEnabled(boolean joinPushdownEnabled) {
        this.joinPushdownEnabled = joinPushdownEnabled;
        return this;
    }

    public boolean isAggregationPushdownEnabled() {
        return this.aggregationPushdownEnabled;
    }

    @Config(value="aggregation-pushdown.enabled")
    @LegacyConfig(value={"allow-aggregation-pushdown"})
    @ConfigDescription(value="Enable aggregation pushdown")
    public JdbcMetadataConfig setAggregationPushdownEnabled(boolean aggregationPushdownEnabled) {
        this.aggregationPushdownEnabled = aggregationPushdownEnabled;
        return this;
    }

    @Config(value="topn-pushdown.enabled")
    @ConfigDescription(value="Enable TopN pushdown")
    public JdbcMetadataConfig setTopNPushdownEnabled(boolean enabled) {
        this.topNPushdownEnabled = enabled;
        return this;
    }

    public Boolean isTopNPushdownEnabled() {
        return this.topNPushdownEnabled;
    }

    @Min(value=1L)
    public @Min(value=1L) int getDomainCompactionThreshold() {
        return this.domainCompactionThreshold;
    }

    @Config(value="domain-compaction-threshold")
    @ConfigDescription(value="Maximum ranges to allow in a tuple domain without compacting it")
    public JdbcMetadataConfig setDomainCompactionThreshold(int domainCompactionThreshold) {
        this.domainCompactionThreshold = domainCompactionThreshold;
        return this;
    }

    @Min(value=1L)
    @Max(value=1000000L)
    public @Min(value=1L) @Max(value=1000000L) int getWriteBatchSize() {
        return this.writeBatchSize;
    }

    @Config(value="write.batch-size")
    @ConfigDescription(value="Maximum number of rows to write in a single batch")
    public JdbcMetadataConfig setWriteBatchSize(int writeBatchSize) {
        this.writeBatchSize = writeBatchSize;
        return this;
    }

    public boolean isNonTransactionalInsert() {
        return this.nonTransactionalInsert;
    }

    @Config(value="insert.non-transactional-insert.enabled")
    @ConfigDescription(value="Do not create temporary table during insert. This means that the write operation can fail and leave the table in an inconsistent state.")
    public JdbcMetadataConfig setNonTransactionalInsert(boolean nonTransactionalInsert) {
        this.nonTransactionalInsert = nonTransactionalInsert;
        return this;
    }
}

