/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.jdbc.ForRecordCursor;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcRecordSet;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;

public class JdbcRecordSetProvider
implements ConnectorRecordSetProvider {
    private final JdbcClient jdbcClient;
    private final ExecutorService executor;

    @Inject
    public JdbcRecordSetProvider(JdbcClient jdbcClient, @ForRecordCursor ExecutorService executor) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        JdbcSplit jdbcSplit = (JdbcSplit)split;
        JdbcTableHandle jdbcTable = (JdbcTableHandle)table;
        jdbcTable.getColumns().ifPresent(tableColumns -> Verify.verify((boolean)ImmutableSet.copyOf((Collection)tableColumns).containsAll((Collection)columns)));
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)((JdbcColumnHandle)columnHandle));
        }
        return new JdbcRecordSet(this.jdbcClient, this.executor, session, jdbcSplit, jdbcTable, (List<JdbcColumnHandle>)handles.build());
    }
}

