/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Throwables;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;

public class RetryingConnectionFactory
implements ConnectionFactory {
    private static final RetryPolicy<Object> RETRY_POLICY = ((RetryPolicy)new RetryPolicy().withMaxDuration(Duration.of(30L, ChronoUnit.SECONDS)).withMaxAttempts(5).withBackoff(50L, 5000L, ChronoUnit.MILLIS, 4.0).handleIf(RetryingConnectionFactory::isSqlRecoverableException)).abortOn(TrinoException.class);
    private final ConnectionFactory delegate;

    public RetryingConnectionFactory(ConnectionFactory delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public Connection openConnection(ConnectorSession session) throws SQLException {
        try {
            return (Connection)Failsafe.with((Policy[])new RetryPolicy[]{RETRY_POLICY}).get(() -> this.delegate.openConnection(session));
        }
        catch (FailsafeException ex) {
            if (ex.getCause() instanceof SQLException) {
                throw (SQLException)ex.getCause();
            }
            throw ex;
        }
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    private static boolean isSqlRecoverableException(Throwable exception) {
        return Throwables.getCausalChain((Throwable)exception).stream().anyMatch(SQLRecoverableException.class::isInstance);
    }
}

