/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.credential;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationLoader;
import io.trino.plugin.jdbc.credential.CredentialConfig;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.CredentialProviderType;
import io.trino.plugin.jdbc.credential.CredentialProviderTypeConfig;
import io.trino.plugin.jdbc.credential.ExtraCredentialConfig;
import io.trino.plugin.jdbc.credential.ExtraCredentialProvider;
import io.trino.plugin.jdbc.credential.ForExtraCredentialProvider;
import io.trino.plugin.jdbc.credential.StaticCredentialProvider;
import io.trino.plugin.jdbc.credential.file.ConfigFileBasedCredentialProviderConfig;
import io.trino.plugin.jdbc.credential.keystore.KeyStoreBasedCredentialProviderConfig;
import io.trino.plugin.jdbc.credential.keystore.KeyStoreUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;

public class CredentialProviderModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindCredentialProviderModule(CredentialProviderType.INLINE, new InlineCredentialProviderModule());
        this.bindCredentialProviderModule(CredentialProviderType.FILE, new ConfigFileBasedCredentialProviderModule());
        this.bindCredentialProviderModule(CredentialProviderType.KEYSTORE, new KeyStoreBasedCredentialProviderModule());
        ConfigBinder.configBinder((Binder)binder).bindConfig(ExtraCredentialConfig.class);
        binder.bind(CredentialProvider.class).to(ExtraCredentialProvider.class).in(Scopes.SINGLETON);
    }

    private void bindCredentialProviderModule(CredentialProviderType name, Module module) {
        this.install(ConditionalModule.conditionalModule(CredentialProviderTypeConfig.class, config -> name == config.getCredentialProviderType(), (Module)module));
    }

    private static class KeyStoreBasedCredentialProviderModule
    implements Module {
        private KeyStoreBasedCredentialProviderModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(KeyStoreBasedCredentialProviderConfig.class);
        }

        @Provides
        @Singleton
        @ForExtraCredentialProvider
        public CredentialProvider getCredentialProvider(KeyStoreBasedCredentialProviderConfig config) throws IOException, GeneralSecurityException {
            KeyStore keyStore = KeyStoreUtils.loadKeyStore(config.getKeyStoreType(), config.getKeyStoreFilePath(), config.getKeyStorePassword());
            String user = KeyStoreUtils.readEntity(keyStore, config.getUserCredentialName(), config.getPasswordForUserCredentialName());
            String password = KeyStoreUtils.readEntity(keyStore, config.getPasswordCredentialName(), config.getPasswordForPasswordCredentialName());
            return new StaticCredentialProvider(Optional.of(user), Optional.of(password));
        }
    }

    private static class ConfigFileBasedCredentialProviderModule
    implements Module {
        private ConfigFileBasedCredentialProviderModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(ConfigFileBasedCredentialProviderConfig.class);
        }

        @Provides
        @Singleton
        @ForExtraCredentialProvider
        public CredentialProvider getCredentialProvider(ConfigFileBasedCredentialProviderConfig fileConfig) throws IOException {
            Map properties = ConfigurationLoader.loadPropertiesFrom((String)fileConfig.getCredentialFile());
            CredentialConfig config = (CredentialConfig)new ConfigurationFactory(properties).build(CredentialConfig.class);
            return new StaticCredentialProvider(config.getConnectionUser(), config.getConnectionPassword());
        }
    }

    private static class InlineCredentialProviderModule
    implements Module {
        private InlineCredentialProviderModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(CredentialConfig.class);
        }

        @Provides
        @Singleton
        @ForExtraCredentialProvider
        public CredentialProvider getCredentialProvider(CredentialConfig config) {
            return new StaticCredentialProvider(config.getConnectionUser(), config.getConnectionPassword());
        }
    }
}

