/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.plugin.jdbc.BaseJdbcConnectorTest;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.sqlserver.DataCompression;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestDistributedQueries;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.sql.TestTable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class BaseSqlServerConnectorTest
extends BaseJdbcConnectorTest {
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        switch (connectorBehavior) {
            case SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY: 
            case SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY: {
                return false;
            }
            case SUPPORTS_AGGREGATION_PUSHDOWN_STDDEV: 
            case SUPPORTS_AGGREGATION_PUSHDOWN_VARIANCE: {
                return true;
            }
            case SUPPORTS_JOIN_PUSHDOWN: {
                return true;
            }
            case SUPPORTS_JOIN_PUSHDOWN_WITH_DISTINCT_FROM: {
                return false;
            }
            case SUPPORTS_COMMENT_ON_TABLE: 
            case SUPPORTS_COMMENT_ON_COLUMN: {
                return false;
            }
            case SUPPORTS_ARRAY: {
                return false;
            }
            case SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS: {
                return false;
            }
            case SUPPORTS_RENAME_SCHEMA: {
                return false;
            }
        }
        return super.hasBehavior(connectorBehavior);
    }

    protected TestTable createTableWithDefaultColumns() {
        return new TestTable(this.onRemoteDatabase(), "table", "(col_required BIGINT NOT NULL,col_nullable BIGINT,col_default BIGINT DEFAULT 43,col_nonnull_default BIGINT NOT NULL DEFAULT 42,col_required2 BIGINT NOT NULL)");
    }

    protected TestTable createTableWithUnsupportedColumn() {
        return new TestTable(this.onRemoteDatabase(), "test_unsupported_column_present", "(one bigint, two sql_variant, three varchar(10))");
    }

    protected Optional<AbstractTestDistributedQueries.DataMappingTestSetup> filterDataMappingSmokeTestData(AbstractTestDistributedQueries.DataMappingTestSetup dataMappingTestSetup) {
        String typeName = dataMappingTestSetup.getTrinoTypeName();
        if (typeName.equals("timestamp(3) with time zone")) {
            return Optional.of(dataMappingTestSetup.asUnsupported());
        }
        if (typeName.equals("varbinary")) {
            return Optional.empty();
        }
        return Optional.of(dataMappingTestSetup);
    }

    @Test
    public void testReadFromView() {
        this.onRemoteDatabase().execute("CREATE VIEW test_view AS SELECT * FROM orders");
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_view"));
        this.assertQuery("SELECT orderkey FROM test_view", "SELECT orderkey FROM orders");
        this.onRemoteDatabase().execute("DROP VIEW IF EXISTS test_view");
    }

    @Test
    public void testColumnComment() throws Exception {
        try (TestTable testTable = new TestTable(this.onRemoteDatabase(), "test_column_comment", "(col1 bigint, col2 bigint, col3 bigint)");){
            this.onRemoteDatabase().execute("EXEC sp_addextendedproperty  'MS_Description', 'test comment',  'Schema', 'dbo',  'Table', '" + testTable.getName() + "',  'Column', 'col1'");
            this.assertQuery("SELECT column_name, comment FROM information_schema.columns WHERE table_schema = 'dbo' AND table_name = '" + testTable.getName() + "'", "VALUES ('col1', null), ('col2', null), ('col3', null)");
        }
    }

    @Test
    public void testPredicatePushdown() throws Exception {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name = 'ROMANIA'"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isNotFullyPushedDown(new Class[]{FilterNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name BETWEEN 'POLAND' AND 'RPA'"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isNotFullyPushedDown(new Class[]{FilterNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name IN ('POLAND', 'ROMANIA', 'VIETNAM')"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25))), (BIGINT '2', BIGINT '21', CAST('VIETNAM' AS varchar(25)))").isNotFullyPushedDown(PlanMatchPattern.node(FilterNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan(tableHandle -> {
            TupleDomain constraint = ((JdbcTableHandle)tableHandle).getConstraint();
            ColumnHandle nameColumn = (ColumnHandle)((Map)constraint.getDomains().orElseThrow()).keySet().stream().map(JdbcColumnHandle.class::cast).filter(column -> column.getColumnName().equals("name")).collect(MoreCollectors.onlyElement());
            return ((Domain)((Map)constraint.getDomains().get()).get(nameColumn)).equals((Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)25), (List)ImmutableList.of((Object)Slices.utf8Slice((String)"POLAND"), (Object)Slices.utf8Slice((String)"ROMANIA"), (Object)Slices.utf8Slice((String)"VIETNAM"))));
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of())}));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)this.getSession()).setCatalogSessionProperty("sqlserver", "domain_compaction_threshold", "1").build(), "SELECT regionkey, nationkey, name FROM nation WHERE name IN ('POLAND', 'ROMANIA', 'VIETNAM')"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25))), (BIGINT '2', BIGINT '21', CAST('VIETNAM' AS varchar(25)))").isNotFullyPushedDown(PlanMatchPattern.node(FilterNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan(tableHandle -> ((JdbcTableHandle)tableHandle).getConstraint().isAll(), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of())}));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name = 'romania'"))).returnsEmptyResult().isNotFullyPushedDown(new Class[]{FilterNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE nationkey = 19"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)this.getSession()).setCatalogSessionProperty("sqlserver", "domain_compaction_threshold", "1").build(), "SELECT regionkey, nationkey, name FROM nation WHERE nationkey IN (19, 21)"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25))), (BIGINT '2', BIGINT '21', CAST('VIETNAM' AS varchar(25)))").isNotFullyPushedDown(new Class[]{FilterNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE nationkey BETWEEN 18.5 AND 19.5"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey FROM orders WHERE orderdate = DATE '1992-09-29'"))).matches("VALUES BIGINT '1250', 34406, 38436, 57570").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM (SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey) WHERE regionkey = 3"))).matches("VALUES (BIGINT '3', BIGINT '77')").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey HAVING sum(nationkey) = 77"))).matches("VALUES (BIGINT '3', BIGINT '77')").isFullyPushedDown();
        try (TestTable testTable = new TestTable(this.onRemoteDatabase(), "test_decimal_pushdown", "(short_decimal decimal(9, 3), long_decimal decimal(30, 10))", List.of("123.321, 123456789.987654321"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName() + " WHERE short_decimal <= 124"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName() + " WHERE short_decimal <= 124"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName() + " WHERE long_decimal <= 123456790"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName() + " WHERE short_decimal <= 123.321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName() + " WHERE long_decimal <= 123456789.987654321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName() + " WHERE short_decimal = 123.321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName() + " WHERE long_decimal = 123456789.987654321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
        }
    }

    @Test
    public void testTooLargeDomainCompactionThreshold() {
        this.assertQueryFails(Session.builder((Session)this.getSession()).setCatalogSessionProperty("sqlserver", "domain_compaction_threshold", "10000").build(), "SELECT * from nation", "Domain compaction threshold \\(10000\\) cannot exceed 500");
    }

    @Test
    public void testNativeLargeIn() {
        this.onRemoteDatabase().execute("SELECT count(*) FROM dbo.orders WHERE " + this.getLongInClause(0, 10000));
    }

    @Test
    public void testNativeMultipleInClauses() {
        String longInClauses = IntStream.range(0, 10).mapToObj(value -> this.getLongInClause(value * 1000, 1000)).collect(Collectors.joining(" OR "));
        this.onRemoteDatabase().execute("SELECT count(*) FROM dbo.orders WHERE " + longInClauses);
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE orders").getOnlyValue())).matches((CharSequence)"CREATE TABLE \\w+\\.\\w+\\.orders \\Q(\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate date,\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority integer,\n   comment varchar(79)\n)\nWITH (\n   data_compression = 'NONE'\n)");
    }

    @Test(dataProvider="dataCompression")
    public void testCreateWithDataCompression(DataCompression dataCompression) {
        String tableName = "test_create_with_compression_" + TestTable.randomTableSuffix();
        String createQuery = String.format("CREATE TABLE sqlserver.dbo.%s (\n   a bigint,\n   b bigint\n)\nWITH (\n   data_compression = '%s'\n)", tableName, dataCompression);
        this.assertUpdate(createQuery);
        Assert.assertEquals((Object)this.getQueryRunner().execute("SHOW CREATE TABLE " + tableName).getOnlyValue(), (Object)createQuery);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @DataProvider
    public Object[][] dataCompression() {
        return new Object[][]{{DataCompression.NONE}, {DataCompression.ROW}, {DataCompression.PAGE}};
    }

    @Test
    public void testShowCreateForPartitionedTablesWithDataCompression() {
        this.onRemoteDatabase().execute("CREATE PARTITION FUNCTION pfSales (DATE)\nAS RANGE LEFT FOR VALUES \n('2013-01-01', '2014-01-01', '2015-01-01')");
        this.onRemoteDatabase().execute("CREATE PARTITION SCHEME psSales\nAS PARTITION pfSales \nALL TO ([PRIMARY])");
        this.onRemoteDatabase().execute("CREATE TABLE partitionedsales (\n   SalesDate DATE,\n   Quantity INT\n) ON psSales(SalesDate) WITH (DATA_COMPRESSION = PAGE)");
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE partitionedsales").getOnlyValue())).matches((CharSequence)"CREATE TABLE \\w+\\.\\w+\\.partitionedsales \\Q(\n   salesdate date,\n   quantity integer\n)");
        this.assertUpdate("DROP TABLE partitionedSales");
        this.onRemoteDatabase().execute("DROP PARTITION SCHEME psSales");
        this.onRemoteDatabase().execute("DROP PARTITION FUNCTION pfSales");
    }

    @Test
    public void testShowCreateForIndexedAndCompressedTable() {
        this.onRemoteDatabase().execute("CREATE TABLE test_show_indexed_table (\n   key1 BIGINT NOT NULL,\n   key2 BIGINT NOT NULL,\n   key3 BIGINT NOT NULL,\n   key4 BIGINT NOT NULL,\n   key5 BIGINT NOT NULL,\n   CONSTRAINT PK_IndexedTable PRIMARY KEY CLUSTERED (key1),\n   CONSTRAINT IX_IndexedTable UNIQUE (key2, key3),\n   INDEX IX_MyTable4 NONCLUSTERED (key4, key5))\n   WITH (DATA_COMPRESSION = PAGE)");
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE test_show_indexed_table").getOnlyValue())).isEqualTo("CREATE TABLE sqlserver.dbo.test_show_indexed_table (\n   key1 bigint NOT NULL,\n   key2 bigint NOT NULL,\n   key3 bigint NOT NULL,\n   key4 bigint NOT NULL,\n   key5 bigint NOT NULL\n)");
        this.assertUpdate("DROP TABLE test_show_indexed_table");
    }

    @Test
    public void testShowCreateForUniqueConstraintCompressedTable() {
        this.onRemoteDatabase().execute("CREATE TABLE test_show_unique_constraint_table (\n   key1 BIGINT NOT NULL,\n   key2 BIGINT NOT NULL,\n   key3 BIGINT NOT NULL,\n   key4 BIGINT NOT NULL,\n   key5 BIGINT NOT NULL,\n   UNIQUE (key1, key4),\n   UNIQUE (key2, key3))\n   WITH (DATA_COMPRESSION = PAGE)");
        Assertions.assertThat((String)((String)this.computeActual("SHOW CREATE TABLE test_show_unique_constraint_table").getOnlyValue())).isEqualTo("CREATE TABLE sqlserver.dbo.test_show_unique_constraint_table (\n   key1 bigint NOT NULL,\n   key2 bigint NOT NULL,\n   key3 bigint NOT NULL,\n   key4 bigint NOT NULL,\n   key5 bigint NOT NULL\n)\nWITH (\n   data_compression = 'PAGE'\n)");
        this.assertUpdate("DROP TABLE test_show_unique_constraint_table");
    }

    private String getLongInClause(int start, int length) {
        String longValues = IntStream.range(start, start + length).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        return "orderkey IN (" + longValues + ")";
    }
}

