/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import io.trino.Session;
import io.trino.plugin.sqlserver.SqlServerQueryRunner;
import io.trino.plugin.sqlserver.TestingSqlServer;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.SqlExecutor;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AssertionsForClassTypes;
import org.testng.annotations.Test;

public abstract class BaseSqlServerTransactionIsolationTest
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        TestingSqlServer sqlServer = (TestingSqlServer)this.closeAfterClass(new TestingSqlServer(this::configureDatabase));
        return SqlServerQueryRunner.createSqlServerQueryRunner(sqlServer, Map.of(), Map.of(), List.of(TpchTable.NATION));
    }

    protected abstract void configureDatabase(SqlExecutor var1, String var2);

    @Test
    public void testCreateReadTable() {
        this.assertUpdate("CREATE TABLE ctas_read AS SELECT * FROM tpch.tiny.nation", "SELECT count(*) FROM nation");
        this.assertQuery("SELECT AVG(LENGTH(name)) FROM ctas_read", "SELECT 7.08");
        this.assertQuery("SELECT SUM(LENGTH(name)) FROM ctas_read WHERE regionkey = 1", "SELECT 38");
        this.assertUpdate("DROP TABLE ctas_read");
    }

    @Test
    public void testDescribeShowTable() {
        this.assertUpdate("CREATE TABLE ctas_describe AS SELECT regionkey, nationkey, comment FROM tpch.tiny.nation", "SELECT count(*) FROM nation");
        MaterializedResult expectedColumns = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"regionkey", "bigint", "", ""}).row(new Object[]{"nationkey", "bigint", "", ""}).row(new Object[]{"comment", "varchar(152)", "", ""}).build();
        MaterializedResult actualColumns = this.computeActual("DESCRIBE ctas_describe");
        AssertionsForClassTypes.assertThat((Object)actualColumns).isEqualTo((Object)expectedColumns);
        MaterializedResult expectedTables = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR}).row(new Object[]{"ctas_describe"}).build();
        MaterializedResult actualTables = this.computeActual("SHOW TABLES LIKE 'ctas_describe'");
        AssertionsForClassTypes.assertThat((Object)actualTables).isEqualTo((Object)expectedTables);
        this.assertUpdate("DROP TABLE ctas_describe");
    }

    @Test
    public void testCreateInsertReadTable() {
        this.assertUpdate("CREATE TABLE insert_table (col INTEGER)");
        this.assertUpdate("INSERT INTO insert_table (col) VALUES (1), (2), (3), (4)", 4L);
        this.assertQuery("SELECT AVG(col) FROM insert_table", "SELECT 2.5");
        this.assertUpdate("DROP TABLE insert_table");
    }
}

