/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.TestingSession;
import io.trino.testing.datatype.CreateAndInsertDataSetup;
import io.trino.testing.datatype.CreateAsSelectDataSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.datatype.SqlDataTypeTest;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TrinoSqlExecutor;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class BaseSqlServerTypeMapping
extends AbstractTestQueryFramework {
    private final ZoneId jvmZone = ZoneId.systemDefault();
    private final LocalDateTime timeGapInJvmZone1 = LocalDateTime.of(1970, 1, 1, 0, 13, 42);
    private final LocalDateTime timeGapInJvmZone2 = LocalDateTime.of(2018, 4, 1, 2, 13, 55, 123000000);
    private final LocalDateTime timeDoubledInJvmZone = LocalDateTime.of(2018, 10, 28, 1, 33, 17, 456000000);
    private final ZoneId vilnius = ZoneId.of("Europe/Vilnius");
    private final LocalDateTime timeGapInVilnius = LocalDateTime.of(2018, 3, 25, 3, 17, 17);
    private final LocalDateTime timeDoubledInVilnius = LocalDateTime.of(2018, 10, 28, 3, 33, 33, 333000000);
    private final ZoneId kathmandu = ZoneId.of("Asia/Kathmandu");
    private final LocalDateTime timeGapInKathmandu = LocalDateTime.of(1986, 1, 1, 0, 13, 7);

    @BeforeClass
    public void setUp() {
        BaseSqlServerTypeMapping.checkIsGap(this.jvmZone, this.timeGapInJvmZone1);
        BaseSqlServerTypeMapping.checkIsGap(this.jvmZone, this.timeGapInJvmZone2);
        BaseSqlServerTypeMapping.checkIsDoubled(this.jvmZone, this.timeDoubledInJvmZone);
        BaseSqlServerTypeMapping.checkIsGap(this.vilnius, this.timeGapInVilnius);
        BaseSqlServerTypeMapping.checkIsDoubled(this.vilnius, this.timeDoubledInVilnius);
        BaseSqlServerTypeMapping.checkIsGap(this.kathmandu, this.timeGapInKathmandu);
    }

    @Test
    public void testBasicTypes() {
        SqlDataTypeTest.create().addRoundTrip("boolean", "null", (Type)BooleanType.BOOLEAN, "CAST(NULL AS BOOLEAN)").addRoundTrip("boolean", "true", (Type)BooleanType.BOOLEAN).addRoundTrip("boolean", "false", (Type)BooleanType.BOOLEAN).addRoundTrip("bigint", "null", (Type)BigintType.BIGINT, "CAST(NULL AS BIGINT)").addRoundTrip("bigint", "123456789012", (Type)BigintType.BIGINT).addRoundTrip("integer", "null", (Type)IntegerType.INTEGER, "CAST(NULL AS INTEGER)").addRoundTrip("integer", "123456789", (Type)IntegerType.INTEGER).addRoundTrip("smallint", "null", (Type)SmallintType.SMALLINT, "CAST(NULL AS SMALLINT)").addRoundTrip("smallint", "32456", (Type)SmallintType.SMALLINT, "SMALLINT '32456'").addRoundTrip("tinyint", "null", (Type)TinyintType.TINYINT, "CAST(NULL AS TINYINT)").addRoundTrip("tinyint", "5", (Type)TinyintType.TINYINT, "TINYINT '5'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_basic_types"));
    }

    @Test
    public void testReal() {
        SqlDataTypeTest.create().addRoundTrip("real", "NULL", (Type)RealType.REAL, "CAST(NULL AS real)").addRoundTrip("real", "3.14", (Type)RealType.REAL, "REAL '3.14'").addRoundTrip("real", "3.1415927", (Type)RealType.REAL, "REAL '3.1415927'").execute(this.getQueryRunner(), this.sqlServerCreateAndInsert("test_real"));
        SqlDataTypeTest.create().addRoundTrip("real", "NULL", (Type)RealType.REAL, "CAST(NULL AS real)").addRoundTrip("real", "3.14", (Type)RealType.REAL, "REAL '3.14'").addRoundTrip("real", "3.1415927", (Type)RealType.REAL, "REAL '3.1415927'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_real"));
    }

    @Test
    public void testDouble() {
        SqlDataTypeTest.create().addRoundTrip("double precision", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS double)").addRoundTrip("double precision", "1.0E100", (Type)DoubleType.DOUBLE, "1.0E100").addRoundTrip("double precision", "123.456E10", (Type)DoubleType.DOUBLE, "123.456E10").execute(this.getQueryRunner(), this.sqlServerCreateAndInsert("test_double"));
        SqlDataTypeTest.create().addRoundTrip("double", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS double)").addRoundTrip("double", "1.0E100", (Type)DoubleType.DOUBLE, "1.0E100").addRoundTrip("double", "123.456E10", (Type)DoubleType.DOUBLE, "123.456E10").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_double"));
    }

    @Test
    public void testDecimal() {
        SqlDataTypeTest.create().addRoundTrip("decimal(3, 0)", "193", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('193' AS decimal(3, 0))").addRoundTrip("decimal(3, 0)", "19", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('19' AS decimal(3, 0))").addRoundTrip("decimal(3, 0)", "-193", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('-193' AS decimal(3, 0))").addRoundTrip("decimal(3, 1)", "10.0", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('10.0' AS decimal(3, 1))").addRoundTrip("decimal(3, 1)", "10.1", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('10.1' AS decimal(3, 1))").addRoundTrip("decimal(3, 1)", "-10.1", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('-10.1' AS decimal(3, 1))").addRoundTrip("decimal(4, 2)", "2", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST('2' AS decimal(4, 2))").addRoundTrip("decimal(4, 2)", "2.3", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST('2.3' AS decimal(4, 2))").addRoundTrip("decimal(24, 2)", "2", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('2' AS decimal(24, 2))").addRoundTrip("decimal(24, 2)", "2.3", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('2.3' AS decimal(24, 2))").addRoundTrip("decimal(24, 2)", "123456789.3", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('123456789.3' AS decimal(24, 2))").addRoundTrip("decimal(24, 4)", "12345678901234567890.31", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST('12345678901234567890.31' AS decimal(24, 4))").addRoundTrip("decimal(30, 5)", "3141592653589793238462643.38327", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST('3141592653589793238462643.38327' AS decimal(30, 5))").addRoundTrip("decimal(30, 5)", "-3141592653589793238462643.38327", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST('-3141592653589793238462643.38327' AS decimal(30, 5))").execute(this.getQueryRunner(), this.sqlServerCreateAndInsert("test_decimal")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_decimal"));
    }

    @Test
    public void testChar() {
        SqlDataTypeTest.create().addRoundTrip("char(1)", "NULL", (Type)CharType.createCharType((long)1L), "CAST(NULL AS char(1))").addRoundTrip("char(10)", "'text_a'", (Type)CharType.createCharType((long)10L), "CAST('text_a' AS char(10))").addRoundTrip("char(255)", "'text_b'", (Type)CharType.createCharType((long)255L), "CAST('text_b' AS char(255))").addRoundTrip("char(4001)", "'text_c'", (Type)CharType.createCharType((long)4001L), "CAST('text_c' AS char(4001))").execute(this.getQueryRunner(), this.sqlServerCreateAndInsert("test_char"));
        SqlDataTypeTest.create().addRoundTrip("char(1)", "NULL", (Type)CharType.createCharType((long)1L), "CAST(NULL AS char(1))").addRoundTrip("char(10)", "'text_a'", (Type)CharType.createCharType((long)10L), "CAST('text_a' AS char(10))").addRoundTrip("char(255)", "'text_b'", (Type)CharType.createCharType((long)255L), "CAST('text_b' AS char(255))").addRoundTrip("char(5)", "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(5))", (Type)CharType.createCharType((long)5L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(5))").addRoundTrip("char(32)", "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(32))", (Type)CharType.createCharType((long)32L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(32))").addRoundTrip("char(20)", "CAST('\ud83d\ude02' AS char(20))", (Type)CharType.createCharType((long)20L), "CAST('\ud83d\ude02' AS char(20))").addRoundTrip("char(77)", "CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS char(77))", (Type)CharType.createCharType((long)77L), "CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS char(77))").execute(this.getQueryRunner(), this.trinoCreateAndInsert(this.getSession(), "test_char")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_char"));
    }

    @Test
    public void testSqlServerNchar() {
        SqlDataTypeTest.create().addRoundTrip("nchar(1)", "NULL", (Type)CharType.createCharType((long)1L), "CAST(NULL AS char(1))").addRoundTrip("nchar(10)", "'text_a'", (Type)CharType.createCharType((long)10L), "CAST('text_a' AS char(10))").addRoundTrip("nchar(255)", "'text_b'", (Type)CharType.createCharType((long)255L), "CAST('text_b' AS char(255))").execute(this.getQueryRunner(), this.sqlServerCreateAndInsert("test_sqlserver_char"));
    }

    @Test
    public void testTrinoLongChar() {
        SqlDataTypeTest.create().addRoundTrip("char(4001)", "'text_c'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR 'text_c'").execute(this.getQueryRunner(), this.trinoCreateAndInsert(this.getSession(), "test_long_char")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_long_char"));
    }

    @Test
    public void testVarchar() {
        SqlDataTypeTest.create().addRoundTrip("varchar(10)", "'text_a'", (Type)VarcharType.createVarcharType((int)10), "CAST('text_a' AS varchar(10))").addRoundTrip("varchar(255)", "'text_b'", (Type)VarcharType.createVarcharType((int)255), "CAST('text_b' AS varchar(255))").addRoundTrip("varchar(4001)", "'text_c'", (Type)VarcharType.createVarcharType((int)4001), "CAST('text_c' AS varchar(4001))").execute(this.getQueryRunner(), this.sqlServerCreateAndInsert("test_varchar"));
        SqlDataTypeTest.create().addRoundTrip("varchar(10)", "'text_a'", (Type)VarcharType.createVarcharType((int)10), "CAST('text_a' AS varchar(10))").addRoundTrip("varchar(255)", "'text_b'", (Type)VarcharType.createVarcharType((int)255), "CAST('text_b' AS varchar(255))").addRoundTrip("varchar(5)", "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(5))", (Type)VarcharType.createVarcharType((int)5), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(5))").addRoundTrip("varchar(32)", "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(32))", (Type)VarcharType.createVarcharType((int)32), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(32))").addRoundTrip("varchar(20)", "CAST('\ud83d\ude02' AS varchar(20))", (Type)VarcharType.createVarcharType((int)20), "CAST('\ud83d\ude02' AS varchar(20))").addRoundTrip("varchar(77)", "CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS varchar(77))", (Type)VarcharType.createVarcharType((int)77), "CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS varchar(77))").execute(this.getQueryRunner(), this.trinoCreateAndInsert(this.getSession(), "test_varchar")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_varchar"));
    }

    @Test
    public void testSqlServerNvarchar() {
        SqlDataTypeTest.create().addRoundTrip("nvarchar(5)", "N'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)5), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(5))").addRoundTrip("nvarchar(32)", "N'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)32), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(32))").addRoundTrip("nvarchar(20)", "N'\ud83d\ude02'", (Type)VarcharType.createVarcharType((int)20), "CAST('\ud83d\ude02' AS varchar(20))").addRoundTrip("nvarchar(77)", "N'\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'", (Type)VarcharType.createVarcharType((int)77), "CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS varchar(77))").execute(this.getQueryRunner(), this.sqlServerCreateAndInsert("test_sqlserver_nvarchar"));
    }

    @Test
    public void testTrinoLongVarchar() {
        SqlDataTypeTest.create().addRoundTrip("varchar(4001)", "'text_c'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR 'text_c'").execute(this.getQueryRunner(), this.trinoCreateAndInsert(this.getSession(), "test_long_varchar")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_long_varchar"));
    }

    @Test
    public void testTrinoUnboundedVarchar() {
        SqlDataTypeTest.create().addRoundTrip("varchar", "'text_a'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR 'text_a'").addRoundTrip("varchar", "'text_b'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR 'text_b'").addRoundTrip("varchar", "'text_d'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR 'text_d'").addRoundTrip("varchar", "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'").addRoundTrip("varchar", "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'").addRoundTrip("varchar", "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'").addRoundTrip("varchar", "VARCHAR '\ud83d\ude02'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\ud83d\ude02'").addRoundTrip("varchar", "VARCHAR '\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR '\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'").addRoundTrip("varchar", "'text_f'", (Type)VarcharType.createUnboundedVarcharType(), "VARCHAR 'text_f'").execute(this.getQueryRunner(), this.trinoCreateAndInsert(this.getSession(), "test_unbounded_varchar")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_unbounded_varchar"));
    }

    @Test
    public void testVarbinary() {
        SqlDataTypeTest.create().addRoundTrip("varbinary", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("varbinary", "X''", (Type)VarbinaryType.VARBINARY, "X''").addRoundTrip("varbinary", "X'68656C6C6F'", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("varbinary", "X'5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD'", (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("varbinary", "X'4261672066756C6C206F6620F09F92B0'", (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("varbinary", "X'0001020304050607080DF9367AA7000000'", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("varbinary", "X'000000000000'", (Type)VarbinaryType.VARBINARY, "X'000000000000'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_varbinary"));
        SqlDataTypeTest.create().addRoundTrip("varbinary(10)", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("varbinary(20)", "0x", (Type)VarbinaryType.VARBINARY, "CAST('' AS varbinary)").addRoundTrip("varbinary(30)", "0x68656C6C6F", (Type)VarbinaryType.VARBINARY, "X'68656C6C6F'").addRoundTrip("varbinary(1000)", "0x5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD", (Type)VarbinaryType.VARBINARY, "X'5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD'").addRoundTrip("varbinary(2000)", "0x4261672066756C6C206F6620F09F92B0", (Type)VarbinaryType.VARBINARY, "X'4261672066756C6C206F6620F09F92B0'").addRoundTrip("varbinary(4000)", "0x0001020304050607080DF9367AA7000000", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("varbinary(4000)", "0x000000000000", (Type)VarbinaryType.VARBINARY, "X'000000000000'").execute(this.getQueryRunner(), this.sqlServerCreateAndInsert("test_varbinary"));
    }

    @Test
    public void testDate() {
        ZoneId jvmZone = ZoneId.systemDefault();
        Preconditions.checkState((boolean)jvmZone.getId().equals("America/Bahia_Banderas"), (Object)"This test assumes certain JVM time zone");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInJvmZone = LocalDate.of(1970, 1, 1);
        BaseSqlServerTypeMapping.checkIsGap(jvmZone, dateOfLocalTimeChangeForwardAtMidnightInJvmZone.atStartOfDay());
        ZoneId someZone = ZoneId.of("Europe/Vilnius");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInSomeZone = LocalDate.of(1983, 4, 1);
        BaseSqlServerTypeMapping.checkIsGap(someZone, dateOfLocalTimeChangeForwardAtMidnightInSomeZone.atStartOfDay());
        LocalDate dateOfLocalTimeChangeBackwardAtMidnightInSomeZone = LocalDate.of(1983, 10, 1);
        BaseSqlServerTypeMapping.checkIsDoubled(someZone, dateOfLocalTimeChangeBackwardAtMidnightInSomeZone.atStartOfDay().minusMinutes(1L));
        SqlDataTypeTest testsSqlServer = SqlDataTypeTest.create().addRoundTrip("date", "NULL", (Type)DateType.DATE, "CAST(NULL AS DATE)").addRoundTrip("date", "'0001-01-01'", (Type)DateType.DATE, "DATE '0001-01-01'").addRoundTrip("date", "'0012-12-12'", (Type)DateType.DATE, "DATE '0012-12-12'").addRoundTrip("date", "'1500-01-01'", (Type)DateType.DATE, "DATE '1500-01-01'").addRoundTrip("date", "'1952-04-03'", (Type)DateType.DATE, "DATE '1952-04-03'").addRoundTrip("date", "'1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "'1970-02-03'", (Type)DateType.DATE, "DATE '1970-02-03'").addRoundTrip("date", "'2017-07-01'", (Type)DateType.DATE, "DATE '2017-07-01'").addRoundTrip("date", "'2017-01-01'", (Type)DateType.DATE, "DATE '2017-01-01'").addRoundTrip("date", "'1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "'1983-04-01'", (Type)DateType.DATE, "DATE '1983-04-01'").addRoundTrip("date", "'1983-10-01'", (Type)DateType.DATE, "DATE '1983-10-01'");
        SqlDataTypeTest testsTrino = SqlDataTypeTest.create().addRoundTrip("date", "NULL", (Type)DateType.DATE, "CAST(NULL AS DATE)").addRoundTrip("date", "DATE '0001-01-01'", (Type)DateType.DATE, "DATE '0001-01-01'").addRoundTrip("date", "DATE '0012-12-12'", (Type)DateType.DATE, "DATE '0012-12-12'").addRoundTrip("date", "DATE '1500-01-01'", (Type)DateType.DATE, "DATE '1500-01-01'").addRoundTrip("date", "DATE '1952-04-03'", (Type)DateType.DATE, "DATE '1952-04-03'").addRoundTrip("date", "DATE '1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "DATE '1970-02-03'", (Type)DateType.DATE, "DATE '1970-02-03'").addRoundTrip("date", "DATE '2017-07-01'", (Type)DateType.DATE, "DATE '2017-07-01'").addRoundTrip("date", "DATE '2017-01-01'", (Type)DateType.DATE, "DATE '2017-01-01'").addRoundTrip("date", "DATE '1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "DATE '1983-04-01'", (Type)DateType.DATE, "DATE '1983-04-01'").addRoundTrip("date", "DATE '1983-10-01'", (Type)DateType.DATE, "DATE '1983-10-01'");
        for (String timeZoneId : ImmutableList.of((Object)TimeZoneKey.UTC_KEY.getId(), (Object)jvmZone.getId(), (Object)someZone.getId())) {
            Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)timeZoneId)).build();
            testsSqlServer.execute(this.getQueryRunner(), session, this.sqlServerCreateAndInsert("test_date"));
            testsTrino.execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_date"));
            testsTrino.execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_date"));
        }
    }

    @Test
    public void testSqlServerDateUnsupported() {
        String unsupportedDate = "'11111-01-01'";
        String tableName = "test_date_unsupported" + TestTable.randomTableSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (test_date date)", tableName));
        try {
            this.assertQueryFails(String.format("INSERT INTO %s VALUES (date %s)", tableName, unsupportedDate), "Failed to insert data: Conversion failed when converting date and/or time from character string.");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testTime() {
        SqlDataTypeTest.create().addRoundTrip("time(0)", "'00:00:00'", (Type)TimeType.createTimeType((int)0), "TIME '00:00:00'").addRoundTrip("time(6)", "'00:00:00.000000'", (Type)TimeType.createTimeType((int)6), "TIME '00:00:00.000000'").addRoundTrip("time(6)", "'00:00:00.123456'", (Type)TimeType.createTimeType((int)6), "TIME '00:00:00.123456'").addRoundTrip("time(0)", "'12:34:56'", (Type)TimeType.createTimeType((int)0), "TIME '12:34:56'").addRoundTrip("time(6)", "'12:34:56.123456'", (Type)TimeType.createTimeType((int)6), "TIME '12:34:56.123456'").addRoundTrip("time(0)", "'23:59:59'", (Type)TimeType.createTimeType((int)0), "TIME '23:59:59'").addRoundTrip("time(1)", "'23:59:59.9'", (Type)TimeType.createTimeType((int)1), "TIME '23:59:59.9'").addRoundTrip("time(2)", "'23:59:59.99'", (Type)TimeType.createTimeType((int)2), "TIME '23:59:59.99'").addRoundTrip("time(3)", "'23:59:59.999'", (Type)TimeType.createTimeType((int)3), "TIME '23:59:59.999'").addRoundTrip("time(4)", "'23:59:59.9999'", (Type)TimeType.createTimeType((int)4), "TIME '23:59:59.9999'").addRoundTrip("time(5)", "'23:59:59.99999'", (Type)TimeType.createTimeType((int)5), "TIME '23:59:59.99999'").addRoundTrip("time(6)", "'23:59:59.999999'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999999'").addRoundTrip("time(7)", "'23:59:59.9999999'", (Type)TimeType.createTimeType((int)7), "TIME '23:59:59.9999999'").execute(this.getQueryRunner(), this.sqlServerCreateAndInsert("test_time"));
        SqlDataTypeTest.create().addRoundTrip("TIME '00:00:00'", "TIME '00:00:00'").addRoundTrip("TIME '00:00:00.000000'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.123456'", "TIME '00:00:00.123456'").addRoundTrip("TIME '12:34:56'", "TIME '12:34:56'").addRoundTrip("TIME '12:34:56.123456'", "TIME '12:34:56.123456'").addRoundTrip("TIME '23:59:59'", "TIME '23:59:59'").addRoundTrip("TIME '23:59:59.9'", "TIME '23:59:59.9'").addRoundTrip("TIME '23:59:59.99'", "TIME '23:59:59.99'").addRoundTrip("TIME '23:59:59.999'", "TIME '23:59:59.999'").addRoundTrip("TIME '23:59:59.9999'", "TIME '23:59:59.9999'").addRoundTrip("TIME '23:59:59.99999'", "TIME '23:59:59.99999'").addRoundTrip("TIME '23:59:59.999999'", "TIME '23:59:59.999999'").addRoundTrip("TIME '23:59:59.9999999'", "TIME '23:59:59.9999999'").execute(this.getQueryRunner(), this.trinoCreateAsSelect(this.getSession(), "test_time")).execute(this.getQueryRunner(), this.trinoCreateAndInsert(this.getSession(), "test_time"));
        SqlDataTypeTest.create().addRoundTrip("TIME '00:00:00.00000001'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '00:00:00.000000000001'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '00:00:00.00000004'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '00:00:00.000000049'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '00:00:00.0000000449'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '00:00:00.00000004449'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '00:00:00.000000044449'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '23:59:59.99999995'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '23:59:59.999999950'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '23:59:59.9999999500'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '23:59:59.99999995000'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '23:59:59.999999950000'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '23:59:59.99999999'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '23:59:59.999999999'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '23:59:59.9999999999'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '23:59:59.99999999999'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '23:59:59.999999999999'", "TIME '00:00:00.0000000'").addRoundTrip("TIME '23:59:59.999999949999'", "TIME '23:59:59.9999999'").execute(this.getQueryRunner(), this.trinoCreateAndInsert(this.getSession(), "test_time")).execute(this.getQueryRunner(), this.trinoCreateAsSelect(this.getSession(), "test_time"));
    }

    @Test(dataProvider="testTimestampDataProvider")
    public void testTimestamp(ZoneId sessionZone) {
        SqlDataTypeTest tests = SqlDataTypeTest.create().addRoundTrip("TIMESTAMP '1958-01-01 13:18:03.123'", "TIMESTAMP '1958-01-01 13:18:03.123'").addRoundTrip("TIMESTAMP '2019-03-18 10:01:17.987'", "TIMESTAMP '2019-03-18 10:01:17.987'").addRoundTrip("TIMESTAMP '2018-10-28 01:33:17.456'", "TIMESTAMP '2018-10-28 01:33:17.456'").addRoundTrip("TIMESTAMP '2018-10-28 03:33:33.333'", "TIMESTAMP '2018-10-28 03:33:33.333'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.000'", "TIMESTAMP '1970-01-01 00:00:00.000'").addRoundTrip("TIMESTAMP '1970-01-01 00:13:42.000'", "TIMESTAMP '1970-01-01 00:13:42.000'").addRoundTrip("TIMESTAMP '2018-04-01 02:13:55.123'", "TIMESTAMP '2018-04-01 02:13:55.123'").addRoundTrip("TIMESTAMP '2018-03-25 03:17:17.000'", "TIMESTAMP '2018-03-25 03:17:17.000'").addRoundTrip("TIMESTAMP '1986-01-01 00:13:07.000'", "TIMESTAMP '1986-01-01 00:13:07.000'").addRoundTrip("TIMESTAMP '1958-01-01 13:18:03.1230000'", "TIMESTAMP '1958-01-01 13:18:03.1230000'").addRoundTrip("TIMESTAMP '2019-03-18 10:01:17.9870000'", "TIMESTAMP '2019-03-18 10:01:17.9870000'").addRoundTrip("TIMESTAMP '2018-10-28 01:33:17.4560000'", "TIMESTAMP '2018-10-28 01:33:17.4560000'").addRoundTrip("TIMESTAMP '2018-10-28 03:33:33.3330000'", "TIMESTAMP '2018-10-28 03:33:33.3330000'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.0000000'", "TIMESTAMP '1970-01-01 00:00:00.0000000'").addRoundTrip("TIMESTAMP '1970-01-01 00:13:42.0000000'", "TIMESTAMP '1970-01-01 00:13:42.0000000'").addRoundTrip("TIMESTAMP '2018-04-01 02:13:55.1230000'", "TIMESTAMP '2018-04-01 02:13:55.1230000'").addRoundTrip("TIMESTAMP '2018-03-25 03:17:17.0000000'", "TIMESTAMP '2018-03-25 03:17:17.0000000'").addRoundTrip("TIMESTAMP '1986-01-01 00:13:07.0000000'", "TIMESTAMP '1986-01-01 00:13:07.0000000'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00'", "TIMESTAMP '1970-01-01 00:00:00'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1'", "TIMESTAMP '1970-01-01 00:00:00.1'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.12'", "TIMESTAMP '1970-01-01 00:00:00.12'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123'", "TIMESTAMP '1970-01-01 00:00:00.123'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234'", "TIMESTAMP '1970-01-01 00:00:00.1234'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.12345'", "TIMESTAMP '1970-01-01 00:00:00.12345'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456'", "TIMESTAMP '1970-01-01 00:00:00.123456'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234567'", "TIMESTAMP '1970-01-01 00:00:00.1234567'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.12345670'", "TIMESTAMP '1970-01-01 00:00:00.1234567'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456749999'", "TIMESTAMP '1970-01-01 00:00:00.1234567'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.12345675'", "TIMESTAMP '1970-01-01 00:00:00.1234568'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.12345679'", "TIMESTAMP '1970-01-01 00:00:00.1234568'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.1230000'", "TIMESTAMP '1969-12-31 23:59:59.1230000'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.1234567'", "TIMESTAMP '1969-12-31 23:59:59.1234567'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00'", "TIMESTAMP '1970-01-01 00:00:00'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1'", "TIMESTAMP '1970-01-01 00:00:00.1'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.9'", "TIMESTAMP '1970-01-01 00:00:00.9'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123'", "TIMESTAMP '1970-01-01 00:00:00.123'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123000'", "TIMESTAMP '1970-01-01 00:00:00.123000'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.999'", "TIMESTAMP '1970-01-01 00:00:00.999'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234567'", "TIMESTAMP '1970-01-01 00:00:00.1234567'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.1'", "TIMESTAMP '2020-09-27 12:34:56.1'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.9'", "TIMESTAMP '2020-09-27 12:34:56.9'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123'", "TIMESTAMP '2020-09-27 12:34:56.123'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123000'", "TIMESTAMP '2020-09-27 12:34:56.123000'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.999'", "TIMESTAMP '2020-09-27 12:34:56.999'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.1234567'", "TIMESTAMP '2020-09-27 12:34:56.1234567'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.12345671'", "TIMESTAMP '1970-01-01 00:00:00.1234567'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234567499'", "TIMESTAMP '1970-01-01 00:00:00.1234567'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456749999'", "TIMESTAMP '1970-01-01 00:00:00.1234567'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.12345675'", "TIMESTAMP '1970-01-01 00:00:00.1234568'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.111222333444'", "TIMESTAMP '1970-01-01 00:00:00.1112223'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.99999995'", "TIMESTAMP '1970-01-01 00:00:01.0000000'").addRoundTrip("TIMESTAMP '1970-01-01 23:59:59.99999995'", "TIMESTAMP '1970-01-02 00:00:00.0000000'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.99999995'", "TIMESTAMP '1970-01-01 00:00:00.0000000'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.999999949999'", "TIMESTAMP '1969-12-31 23:59:59.9999999'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.99999994'", "TIMESTAMP '1969-12-31 23:59:59.9999999'");
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        tests.execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_timestamp"));
        tests.execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(this.getSession(), "test_timestamp"));
        tests.execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_timestamp"));
    }

    @Test
    public void testSqlServerDatetime2() {
        SqlDataTypeTest.create().addRoundTrip("DATETIME2(0)", "'1970-01-01 00:00:00'", (Type)TimestampType.createTimestampType((int)0), "TIMESTAMP '1970-01-01 00:00:00'").addRoundTrip("DATETIME2(1)", "'1970-01-01 00:00:00.1'", (Type)TimestampType.createTimestampType((int)1), "TIMESTAMP '1970-01-01 00:00:00.1'").addRoundTrip("DATETIME2(1)", "'1970-01-01 00:00:00.9'", (Type)TimestampType.createTimestampType((int)1), "TIMESTAMP '1970-01-01 00:00:00.9'").addRoundTrip("DATETIME2(3)", "'1970-01-01 00:00:00.123'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1970-01-01 00:00:00.123'").addRoundTrip("DATETIME2(6)", "'1970-01-01 00:00:00.123000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:00.123000'").addRoundTrip("DATETIME2(3)", "'1970-01-01 00:00:00.999'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1970-01-01 00:00:00.999'").addRoundTrip("DATETIME2(7)", "'1970-01-01 00:00:00.1234567'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '1970-01-01 00:00:00.1234567'").addRoundTrip("DATETIME2(1)", "'2020-09-27 12:34:56.1'", (Type)TimestampType.createTimestampType((int)1), "TIMESTAMP '2020-09-27 12:34:56.1'").addRoundTrip("DATETIME2(1)", "'2020-09-27 12:34:56.9'", (Type)TimestampType.createTimestampType((int)1), "TIMESTAMP '2020-09-27 12:34:56.9'").addRoundTrip("DATETIME2(3)", "'2020-09-27 12:34:56.123'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2020-09-27 12:34:56.123'").addRoundTrip("DATETIME2(6)", "'2020-09-27 12:34:56.123000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2020-09-27 12:34:56.123000'").addRoundTrip("DATETIME2(3)", "'2020-09-27 12:34:56.999'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2020-09-27 12:34:56.999'").addRoundTrip("DATETIME2(7)", "'2020-09-27 12:34:56.1234567'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '2020-09-27 12:34:56.1234567'").addRoundTrip("DATETIME2(7)", "'1970-01-01 00:00:00'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '1970-01-01 00:00:00.0000000'").addRoundTrip("DATETIME2(7)", "'1970-01-01 00:00:00.1'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '1970-01-01 00:00:00.1000000'").addRoundTrip("DATETIME2(7)", "'1970-01-01 00:00:00.9'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '1970-01-01 00:00:00.9000000'").addRoundTrip("DATETIME2(7)", "'1970-01-01 00:00:00.123'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '1970-01-01 00:00:00.1230000'").addRoundTrip("DATETIME2(7)", "'1970-01-01 00:00:00.123000'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '1970-01-01 00:00:00.1230000'").addRoundTrip("DATETIME2(7)", "'1970-01-01 00:00:00.999'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '1970-01-01 00:00:00.9990000'").addRoundTrip("DATETIME2(7)", "'1970-01-01 00:00:00.1234567'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '1970-01-01 00:00:00.1234567'").addRoundTrip("DATETIME2(7)", "'2020-09-27 12:34:56.1'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '2020-09-27 12:34:56.1000000'").addRoundTrip("DATETIME2(7)", "'2020-09-27 12:34:56.9'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '2020-09-27 12:34:56.9000000'").addRoundTrip("DATETIME2(7)", "'2020-09-27 12:34:56.123'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '2020-09-27 12:34:56.1230000'").addRoundTrip("DATETIME2(7)", "'2020-09-27 12:34:56.123000'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '2020-09-27 12:34:56.1230000'").addRoundTrip("DATETIME2(7)", "'2020-09-27 12:34:56.999'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '2020-09-27 12:34:56.9990000'").addRoundTrip("DATETIME2(7)", "'2020-09-27 12:34:56.1234567'", (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '2020-09-27 12:34:56.1234567'").execute(this.getQueryRunner(), this.sqlServerCreateAndInsert("test_sqlserver_timestamp"));
    }

    @DataProvider
    public Object[][] testTimestampDataProvider() {
        return new Object[][]{{ZoneOffset.UTC}, {ZoneId.systemDefault()}, {ZoneId.of("Europe/Vilnius")}, {ZoneId.of("Asia/Kathmandu")}, {ZoneId.of(TestingSession.DEFAULT_TIME_ZONE_KEY.getId())}};
    }

    protected DataSetup trinoCreateAsSelect(String tableNamePrefix) {
        return this.trinoCreateAsSelect(this.getSession(), tableNamePrefix);
    }

    protected DataSetup trinoCreateAsSelect(Session session, String tableNamePrefix) {
        return new CreateAsSelectDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    protected DataSetup trinoCreateAndInsert(Session session, String tableNamePrefix) {
        return new CreateAndInsertDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    protected DataSetup sqlServerCreateAndInsert(String tableNamePrefix) {
        return new CreateAndInsertDataSetup(this.onRemoteDatabase(), tableNamePrefix);
    }

    private static void checkIsDoubled(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((zone.getRules().getValidOffsets(dateTime).size() == 2 ? 1 : 0) != 0, (String)"Expected %s to be doubled in %s", (Object)dateTime, (Object)zone);
    }

    private static boolean isGap(ZoneId zone, LocalDateTime dateTime) {
        return zone.getRules().getValidOffsets(dateTime).isEmpty();
    }

    private static void checkIsGap(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((boolean)BaseSqlServerTypeMapping.isGap(zone, dateTime), (String)"Expected %s to be a gap in %s", (Object)dateTime, (Object)zone);
    }

    protected abstract SqlExecutor onRemoteDatabase();
}

