/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.plugin.sqlserver.SqlServerPlugin;
import io.trino.plugin.sqlserver.TestingSqlServer;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.security.Identity;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.util.HashMap;
import java.util.Map;

public final class SqlServerQueryRunner {
    private static final String CATALOG = "sqlserver";
    private static final String TEST_SCHEMA = "dbo";

    private SqlServerQueryRunner() {
    }

    public static QueryRunner createSqlServerQueryRunner(TestingSqlServer testingSqlServer, Map<String, String> extraProperties, Map<String, String> connectorProperties, Iterable<TpchTable<?>> tables) throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)SqlServerQueryRunner.createSession(testingSqlServer.getUsername())).setExtraProperties(extraProperties).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            connectorProperties = new HashMap<String, String>((Map<String, String>)ImmutableMap.copyOf(connectorProperties));
            connectorProperties.putIfAbsent("connection-url", testingSqlServer.getJdbcUrl());
            connectorProperties.putIfAbsent("connection-user", testingSqlServer.getUsername());
            connectorProperties.putIfAbsent("connection-password", testingSqlServer.getPassword());
            connectorProperties.putIfAbsent("allow-drop-table", "true");
            queryRunner.installPlugin((Plugin)new SqlServerPlugin());
            queryRunner.createCatalog(CATALOG, CATALOG, connectorProperties);
            QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Session)SqlServerQueryRunner.createSession(testingSqlServer.getUsername()), tables);
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    private static Session createSession(String username) {
        return TestingSession.testSessionBuilder().setCatalog(CATALOG).setSchema(TEST_SCHEMA).setIdentity(Identity.ofUser((String)username)).build();
    }

    public static void main(String[] args) throws Exception {
        Logging.initialize();
        TestingSqlServer testingSqlServer = new TestingSqlServer();
        Runtime.getRuntime().addShutdownHook(new Thread(testingSqlServer::close));
        DistributedQueryRunner queryRunner = (DistributedQueryRunner)SqlServerQueryRunner.createSqlServerQueryRunner(testingSqlServer, (Map<String, String>)ImmutableMap.of((Object)"http-server.http.port", (Object)"8080"), (Map<String, String>)ImmutableMap.of(), ImmutableList.of());
        Logger log = Logger.get(SqlServerQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }
}

