/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.jdbc.BaseCaseInsensitiveMappingTest;
import io.trino.plugin.jdbc.mapping.RuleBasedIdentifierMappingUtils;
import io.trino.plugin.sqlserver.SqlServerQueryRunner;
import io.trino.plugin.sqlserver.TestingSqlServer;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.SqlExecutor;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSqlServerCaseInsensitiveMapping
extends BaseCaseInsensitiveMappingTest {
    private Path mappingFile;
    private TestingSqlServer sqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.mappingFile = RuleBasedIdentifierMappingUtils.createRuleBasedIdentifierMappingFile();
        this.sqlServer = (TestingSqlServer)this.closeAfterClass(new TestingSqlServer());
        return SqlServerQueryRunner.createSqlServerQueryRunner(this.sqlServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.builder().put((Object)"case-insensitive-name-matching", (Object)"true").put((Object)"case-insensitive-name-matching.config-file", (Object)this.mappingFile.toFile().getAbsolutePath()).put((Object)"case-insensitive-name-matching.config-file.refresh-period", (Object)"1ms").build(), ImmutableList.of());
    }

    protected Path getMappingFile() {
        return Objects.requireNonNull(this.mappingFile, "mappingFile is null");
    }

    protected SqlExecutor onRemoteDatabase() {
        return Objects.requireNonNull(this.sqlServer, "sqlServer is null")::execute;
    }

    @Test
    public void testSqlServerCollation() throws Exception {
        try (Connection connection = this.sqlServer.createConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT SERVERPROPERTY ('Collation')");){
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            Assertions.assertThat((String)resultSet.getString(1)).isEqualTo("Latin1_General_CS_AS");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
        }
    }
}

