/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.math.RoundingMode;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class DecimalConfig {
    private DecimalMapping decimalMapping = DecimalMapping.STRICT;
    private int decimalDefaultScale;
    private RoundingMode decimalRoundingMode = RoundingMode.UNNECESSARY;

    @NotNull
    public DecimalMapping getDecimalMapping() {
        return this.decimalMapping;
    }

    @Config(value="decimal-mapping")
    @ConfigDescription(value="Decimal mapping for unspecified and exceeding precision decimals. STRICT skips them. ALLOW_OVERFLOW requires setting proper decimal scale and rounding mode")
    public DecimalConfig setDecimalMapping(DecimalMapping decimalMapping) {
        this.decimalMapping = decimalMapping;
        return this;
    }

    @Min(value=0L)
    @Max(value=38L)
    public @Min(value=0L) @Max(value=38L) int getDecimalDefaultScale() {
        return this.decimalDefaultScale;
    }

    @Config(value="decimal-default-scale")
    @ConfigDescription(value="Default decimal scale for mapping unspecified and exceeding precision decimals. Not used when decimal_mapping is set to STRICT")
    public DecimalConfig setDecimalDefaultScale(Integer decimalDefaultScale) {
        this.decimalDefaultScale = decimalDefaultScale;
        return this;
    }

    @NotNull
    public RoundingMode getDecimalRoundingMode() {
        return this.decimalRoundingMode;
    }

    @Config(value="decimal-rounding-mode")
    @ConfigDescription(value="Rounding mode for mapping unspecified and exceeding precision decimals. Not used whendecimal_mappingis set to STRICT")
    public DecimalConfig setDecimalRoundingMode(RoundingMode decimalRoundingMode) {
        this.decimalRoundingMode = decimalRoundingMode;
        return this;
    }

    public static enum DecimalMapping {
        STRICT,
        ALLOW_OVERFLOW;

    }
}

