/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.credential.CredentialPropertiesProvider;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.DefaultCredentialPropertiesProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class DriverConnectionFactory
implements ConnectionFactory {
    private final Driver driver;
    private final String connectionUrl;
    private final Properties connectionProperties;
    private final CredentialPropertiesProvider credentialPropertiesProvider;

    public DriverConnectionFactory(Driver driver, BaseJdbcConfig config, CredentialProvider credentialProvider) {
        this(driver, config.getConnectionUrl(), new Properties(), credentialProvider);
    }

    public DriverConnectionFactory(Driver driver, String connectionUrl, Properties connectionProperties, CredentialProvider credentialProvider) {
        this(driver, connectionUrl, connectionProperties, new DefaultCredentialPropertiesProvider(credentialProvider));
    }

    public DriverConnectionFactory(Driver driver, String connectionUrl, Properties connectionProperties, CredentialPropertiesProvider credentialPropertiesProvider) {
        this.driver = Objects.requireNonNull(driver, "driver is null");
        this.connectionUrl = Objects.requireNonNull(connectionUrl, "connectionUrl is null");
        this.connectionProperties = new Properties();
        this.connectionProperties.putAll((Map<?, ?>)Objects.requireNonNull(connectionProperties, "connectionProperties is null"));
        this.credentialPropertiesProvider = Objects.requireNonNull(credentialPropertiesProvider, "credentialPropertiesProvider is null");
    }

    @Override
    public Connection openConnection(ConnectorSession session) throws SQLException {
        Properties properties = this.getCredentialProperties(session.getIdentity());
        Connection connection = this.driver.connect(this.connectionUrl, properties);
        Preconditions.checkState((connection != null ? 1 : 0) != 0, (String)"Driver returned null connection, make sure the connection URL '%s' is valid for the driver %s", (Object)this.connectionUrl, (Object)this.driver);
        return connection;
    }

    private Properties getCredentialProperties(ConnectorIdentity identity) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.connectionProperties);
        properties.putAll((Map<?, ?>)this.credentialPropertiesProvider.getCredentialProperties(identity));
        return properties;
    }
}

