/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.CachingJdbcClient;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DefaultJdbcMetadataFactory;
import io.trino.plugin.jdbc.ForLazyConnectionFactory;
import io.trino.plugin.jdbc.ForRecordCursor;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcConnector;
import io.trino.plugin.jdbc.JdbcDiagnosticModule;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcMetadataFactory;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.JdbcPageSinkProvider;
import io.trino.plugin.jdbc.JdbcRecordSetProvider;
import io.trino.plugin.jdbc.JdbcSplitManager;
import io.trino.plugin.jdbc.LazyConnectionFactory;
import io.trino.plugin.jdbc.MaxDomainCompactionThreshold;
import io.trino.plugin.jdbc.StatsCollecting;
import io.trino.plugin.jdbc.TablePropertiesProvider;
import io.trino.plugin.jdbc.TypeHandlingJdbcConfig;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.mapping.IdentifierMappingModule;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.procedure.Procedure;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.PreDestroy;
import javax.inject.Provider;

public class JdbcModule
extends AbstractConfigurationAwareModule {
    private final String catalogName;

    public JdbcModule(String catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    public void setup(Binder binder) {
        binder.bind(CatalogName.class).toInstance((Object)new CatalogName(this.catalogName));
        this.install(new JdbcDiagnosticModule());
        this.install((Module)new IdentifierMappingModule());
        OptionalBinder.newOptionalBinder((Binder)binder, ConnectorAccessControl.class);
        JdbcModule.procedureBinder(binder);
        JdbcModule.tablePropertiesProviderBinder(binder);
        OptionalBinder.newOptionalBinder((Binder)binder, JdbcMetadataFactory.class).setDefault().to(DefaultJdbcMetadataFactory.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, ConnectorSplitManager.class).setDefault().to(JdbcSplitManager.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, ConnectorRecordSetProvider.class).setDefault().to(JdbcRecordSetProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, ConnectorPageSinkProvider.class).setDefault().to(JdbcPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(JdbcConnector.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcMetadataConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(BaseJdbcConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(TypeHandlingJdbcConfig.class);
        JdbcModule.bindSessionPropertiesProvider(binder, TypeHandlingJdbcSessionProperties.class);
        JdbcModule.bindSessionPropertiesProvider(binder, JdbcMetadataSessionProperties.class);
        binder.bind(CachingJdbcClient.class).in(Scopes.SINGLETON);
        binder.bind(JdbcClient.class).to(Key.get(CachingJdbcClient.class)).in(Scopes.SINGLETON);
        binder.bind(ConnectionFactory.class).annotatedWith(ForLazyConnectionFactory.class).to(Key.get(ConnectionFactory.class, StatsCollecting.class)).in(Scopes.SINGLETON);
        binder.bind(ConnectionFactory.class).to(LazyConnectionFactory.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Integer.TYPE, MaxDomainCompactionThreshold.class));
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(ExecutorService.class, ForRecordCursor.class)).setDefault().toProvider(MoreExecutors::newDirectExecutorService).in(Scopes.SINGLETON);
    }

    public static Multibinder<SessionPropertiesProvider> sessionPropertiesProviderBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class);
    }

    public static void bindSessionPropertiesProvider(Binder binder, Class<? extends SessionPropertiesProvider> type) {
        JdbcModule.sessionPropertiesProviderBinder(binder).addBinding().to(type).in(Scopes.SINGLETON);
    }

    public static Multibinder<Procedure> procedureBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, Procedure.class);
    }

    public static void bindProcedure(Binder binder, Class<? extends Provider<? extends Procedure>> type) {
        JdbcModule.procedureBinder(binder).addBinding().toProvider(type).in(Scopes.SINGLETON);
    }

    public static Multibinder<TablePropertiesProvider> tablePropertiesProviderBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, TablePropertiesProvider.class);
    }

    public static void bindTablePropertiesProvider(Binder binder, Class<? extends TablePropertiesProvider> type) {
        JdbcModule.tablePropertiesProviderBinder(binder).addBinding().to(type).in(Scopes.SINGLETON);
    }

    @PreDestroy
    public void shutdownRecordCursorExecutor(@ForRecordCursor ExecutorService executor) {
        executor.shutdownNow();
    }
}

