/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.jdbc.ForRecordCursor;
import io.trino.plugin.jdbc.RemoteQueryCancellationConfig;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Provider;

public class RemoteQueryCancellationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install(ConditionalModule.conditionalModule(RemoteQueryCancellationConfig.class, RemoteQueryCancellationConfig::isRemoteQueryCancellationEnabled, (Module)RemoteQueryCancellationModule.bindForRecordCursor()));
    }

    private static Module bindForRecordCursor() {
        return binder -> OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(ExecutorService.class, ForRecordCursor.class)).setBinding().toProvider(RecordCursorExecutorServiceProvider.class).in(Scopes.SINGLETON);
    }

    private static class RecordCursorExecutorServiceProvider
    implements Provider<ExecutorService> {
        private final CatalogName catalogName;

        @Inject
        public RecordCursorExecutorServiceProvider(CatalogName catalogName) {
            this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        }

        public ExecutorService get() {
            return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)String.format("%s-record-cursor-%%d", this.catalogName)));
        }
    }
}

