/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import java.util.Objects;
import java.util.Optional;

public final class RemoteTableName {
    private final Optional<String> catalogName;
    private final Optional<String> schemaName;
    private final String tableName;

    @JsonCreator
    public RemoteTableName(Optional<String> catalogName, Optional<String> schemaName, String tableName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    @JsonProperty
    public Optional<String> getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteTableName that = (RemoteTableName)o;
        return this.catalogName.equals(that.catalogName) && this.schemaName.equals(that.schemaName) && this.tableName.equals(that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.tableName);
    }

    public String toString() {
        return Joiner.on((String)".").skipNulls().join(this.catalogName.orElse(null), this.schemaName.orElse(null), new Object[]{this.tableName});
    }
}

