/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.AggregateFunctionPatterns;
import io.trino.plugin.base.expression.AggregateFunctionRule;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.CharType;
import io.trino.spi.type.VarcharType;
import java.util.Optional;
import java.util.Set;

public class ImplementMinMax
implements AggregateFunctionRule<JdbcExpression> {
    private static final Capture<Variable> INPUT = Capture.newCapture();
    private final boolean isRemoteCollationSensitive;

    public ImplementMinMax(boolean isRemoteCollationSensitive) {
        this.isRemoteCollationSensitive = isRemoteCollationSensitive;
    }

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().matching(Set.of("min", "max")::contains)).with(AggregateFunctionPatterns.singleInput().matching(AggregateFunctionPatterns.variable().capturedAs(INPUT)));
    }

    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext context) {
        Variable input = (Variable)captures.get(INPUT);
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.getAssignment(input.getName());
        Verify.verify((boolean)columnHandle.getColumnType().equals(aggregateFunction.getOutputType()));
        if (!this.isRemoteCollationSensitive && (columnHandle.getColumnType() instanceof CharType || columnHandle.getColumnType() instanceof VarcharType)) {
            return Optional.empty();
        }
        return Optional.of(new JdbcExpression(String.format("%s(%s)", aggregateFunction.getFunctionName(), context.getIdentifierQuote().apply(columnHandle.getColumnName())), columnHandle.getJdbcTypeHandle()));
    }
}

