/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.jmx;

import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.jmx.JdbcClientStats;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public final class StatisticsAwareJdbcClient
implements JdbcClient {
    private final JdbcClientStats stats = new JdbcClientStats();
    private final JdbcClient delegate;

    public StatisticsAwareJdbcClient(JdbcClient delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    private JdbcClient delegate() {
        return this.delegate;
    }

    @Managed
    @Flatten
    public JdbcClientStats getStats() {
        return this.stats;
    }

    @Override
    public boolean schemaExists(ConnectorSession session, String schema) {
        return this.stats.getSchemaExists().wrap(() -> this.delegate().schemaExists(session, schema));
    }

    @Override
    public Set<String> getSchemaNames(ConnectorSession session) {
        return this.stats.getGetSchemaNames().wrap(() -> this.delegate().getSchemaNames(session));
    }

    @Override
    public List<SchemaTableName> getTableNames(ConnectorSession session, Optional<String> schema) {
        return this.stats.getGetTableNames().wrap(() -> this.delegate().getTableNames(session, schema));
    }

    @Override
    public Optional<JdbcTableHandle> getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.stats.getGetTableHandle().wrap(() -> this.delegate().getTableHandle(session, schemaTableName));
    }

    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.stats.getGetColumns().wrap(() -> this.delegate().getColumns(session, tableHandle));
    }

    @Override
    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        return this.stats.getToPrestoType().wrap(() -> this.delegate().toColumnMapping(session, connection, typeHandle));
    }

    @Override
    public List<ColumnMapping> toColumnMappings(ConnectorSession session, List<JdbcTypeHandle> typeHandles) {
        return this.stats.getGetColumnMappings().wrap(() -> this.delegate.toColumnMappings(session, typeHandles));
    }

    @Override
    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        return this.stats.getToWriteMapping().wrap(() -> this.delegate().toWriteMapping(session, type));
    }

    @Override
    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return this.delegate().supportsAggregationPushdown(session, table, aggregates, assignments, groupingSets);
    }

    @Override
    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.stats.getImplementAggregation().wrap(() -> this.delegate().implementAggregation(session, aggregate, assignments));
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, JdbcTableHandle layoutHandle) {
        return this.stats.getGetSplits().wrap(() -> this.delegate().getSplits(session, layoutHandle));
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcSplit split) throws SQLException {
        return this.stats.getGetConnectionWithSplit().wrap(() -> this.delegate().getConnection(session, split));
    }

    @Override
    public void abortReadConnection(Connection connection) throws SQLException {
        this.stats.getAbortReadConnection().wrap(() -> this.delegate().abortReadConnection(connection));
    }

    @Override
    public PreparedQuery prepareQuery(ConnectorSession session, JdbcTableHandle table, Optional<List<List<JdbcColumnHandle>>> groupingSets, List<JdbcColumnHandle> columns, Map<String, String> columnExpressions) {
        return this.stats.getPrepareQuery().wrap(() -> this.delegate().prepareQuery(session, table, groupingSets, columns, columnExpressions));
    }

    @Override
    public PreparedStatement buildSql(ConnectorSession session, Connection connection, JdbcSplit split, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columnHandles) throws SQLException {
        return this.stats.getBuildSql().wrap(() -> this.delegate().buildSql(session, connection, split, tableHandle, columnHandles));
    }

    @Override
    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        return this.stats.getImplementJoin().wrap(() -> this.delegate().implementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics));
    }

    @Override
    public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        this.stats.getSetColumnComment().wrap(() -> this.delegate().setColumnComment(session, handle, column, comment));
    }

    @Override
    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        this.stats.getAddColumn().wrap(() -> this.delegate().addColumn(session, handle, column));
    }

    @Override
    public void dropColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        this.stats.getDropColumn().wrap(() -> this.delegate().dropColumn(session, handle, column));
    }

    @Override
    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        this.stats.getRenameColumn().wrap(() -> this.delegate().renameColumn(session, handle, jdbcColumn, newColumnName));
    }

    @Override
    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        this.stats.getRenameTable().wrap(() -> this.delegate().renameTable(session, handle, newTableName));
    }

    @Override
    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        this.stats.getCreateTable().wrap(() -> this.delegate().createTable(session, tableMetadata));
    }

    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return this.stats.getBeginCreateTable().wrap(() -> this.delegate().beginCreateTable(session, tableMetadata));
    }

    @Override
    public void commitCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        this.stats.getCommitCreateTable().wrap(() -> this.delegate().commitCreateTable(session, handle));
    }

    @Override
    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columns) {
        return this.stats.getBeginInsertTable().wrap(() -> this.delegate().beginInsertTable(session, tableHandle, columns));
    }

    @Override
    public void finishInsertTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        this.stats.getFinishInsertTable().wrap(() -> this.delegate().finishInsertTable(session, handle));
    }

    @Override
    public void dropTable(ConnectorSession session, JdbcTableHandle jdbcTableHandle) {
        this.stats.getDropTable().wrap(() -> this.delegate().dropTable(session, jdbcTableHandle));
    }

    @Override
    public void rollbackCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        this.stats.getRollbackCreateTable().wrap(() -> this.delegate().rollbackCreateTable(session, handle));
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        return this.stats.getBuildInsertSql().wrap(() -> this.delegate().buildInsertSql(handle, columnWriters));
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcOutputTableHandle handle) throws SQLException {
        return this.stats.getGetConnectionWithHandle().wrap(() -> this.delegate().getConnection(session, handle));
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        return this.stats.getGetPreparedStatement().wrap(() -> this.delegate().getPreparedStatement(connection, sql));
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle, TupleDomain<ColumnHandle> tupleDomain) {
        return this.stats.getGetTableStatistics().wrap(() -> this.delegate().getTableStatistics(session, handle, tupleDomain));
    }

    @Override
    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        return this.delegate().supportsTopN(session, handle, sortOrder);
    }

    @Override
    public boolean isTopNGuaranteed(ConnectorSession session) {
        return this.delegate().isTopNGuaranteed(session);
    }

    @Override
    public boolean supportsLimit() {
        return this.delegate().supportsLimit();
    }

    @Override
    public boolean isLimitGuaranteed(ConnectorSession session) {
        return this.delegate().isLimitGuaranteed(session);
    }

    @Override
    public void createSchema(ConnectorSession session, String schemaName) {
        this.stats.getCreateSchema().wrap(() -> this.delegate().createSchema(session, schemaName));
    }

    @Override
    public void dropSchema(ConnectorSession session, String schemaName) {
        this.stats.getDropSchema().wrap(() -> this.delegate().dropSchema(session, schemaName));
    }

    @Override
    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.delegate().getSystemTable(session, tableName);
    }

    @Override
    public String quoted(String name) {
        return this.delegate().quoted(name);
    }

    @Override
    public String quoted(RemoteTableName remoteTableName) {
        return this.delegate().quoted(remoteTableName);
    }

    @Override
    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.delegate().getTableProperties(session, tableHandle);
    }

    @Override
    public Optional<TableScanRedirectApplicationResult> getTableScanRedirection(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.stats.getGetTableScanRedirection().wrap(() -> this.delegate().getTableScanRedirection(session, tableHandle));
    }

    @Override
    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        return this.stats.getDelete().wrap(() -> this.delegate().delete(session, handle));
    }
}

