/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.mapping;

import com.google.common.base.Suppliers;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.mapping.CachingIdentifierMapping;
import io.trino.plugin.jdbc.mapping.DefaultIdentifierMapping;
import io.trino.plugin.jdbc.mapping.ForwardingIdentifierMapping;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.mapping.IdentifierMappingRules;
import io.trino.plugin.jdbc.mapping.MappingConfig;
import io.trino.plugin.jdbc.mapping.RuleBasedIdentifierMapping;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Qualifier;

public final class IdentifierMappingModule
extends AbstractConfigurationAwareModule {
    private static final Logger log = Logger.get(IdentifierMappingModule.class);

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(MappingConfig.class);
        binder.bind(DefaultIdentifierMapping.class).in(Scopes.SINGLETON);
        MappingConfig config = (MappingConfig)this.buildConfigObject(MappingConfig.class);
        if (config.isCaseInsensitiveNameMatching()) {
            Provider baseJdbcClientProvider = binder.getProvider(Key.get(JdbcClient.class, ForBaseJdbc.class));
            binder.bind(BaseJdbcClient.class).toProvider(() -> (BaseJdbcClient)baseJdbcClientProvider.get());
            binder.bind(IdentifierMapping.class).annotatedWith(ForCachingIdentifierMapping.class).to(DefaultIdentifierMapping.class).in(Scopes.SINGLETON);
            binder.bind(IdentifierMapping.class).annotatedWith(ForRuleBasedIdentifierMapping.class).to(CachingIdentifierMapping.class).in(Scopes.SINGLETON);
        } else {
            binder.bind(IdentifierMapping.class).annotatedWith(ForRuleBasedIdentifierMapping.class).to(DefaultIdentifierMapping.class).in(Scopes.SINGLETON);
        }
        if (config.getCaseInsensitiveNameMatchingConfigFile().isPresent()) {
            this.install((Module)new RuleBasedIdentifierMappingModule());
        } else {
            binder.bind(IdentifierMapping.class).to(Key.get(IdentifierMapping.class, ForRuleBasedIdentifierMapping.class)).in(Scopes.SINGLETON);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Qualifier
    public static @interface ForRuleBasedIdentifierMapping {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Qualifier
    public static @interface ForCachingIdentifierMapping {
    }

    private static final class RuleBasedIdentifierMappingModule
    extends AbstractConfigurationAwareModule {
        private RuleBasedIdentifierMappingModule() {
        }

        protected void setup(Binder binder) {
        }

        @Singleton
        @Provides
        public IdentifierMapping getIdentifierMapping(CatalogName catalogName, @ForRuleBasedIdentifierMapping IdentifierMapping identifierMapping, MappingConfig config) {
            String configFile = config.getCaseInsensitiveNameMatchingConfigFile().orElseThrow(() -> new IllegalStateException("Missing case insensitive matching config file"));
            Optional<Duration> refreshPeriod = config.getCaseInsensitiveNameMatchingConfigFileRefreshPeriod();
            if (refreshPeriod.isPresent()) {
                return ForwardingIdentifierMapping.of((Supplier<IdentifierMapping>)Suppliers.memoizeWithExpiration(() -> {
                    log.info("Refreshing identifier mapping for %s from %s", new Object[]{catalogName, configFile});
                    return new RuleBasedIdentifierMapping(RuleBasedIdentifierMappingModule.createRules(configFile), identifierMapping);
                }, (long)refreshPeriod.get().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
            return new RuleBasedIdentifierMapping(RuleBasedIdentifierMappingModule.createRules(configFile), identifierMapping);
        }

        private static IdentifierMappingRules createRules(String configFile) {
            return (IdentifierMappingRules)JsonUtils.parseJson((Path)Paths.get(configFile, new String[0]), IdentifierMappingRules.class);
        }
    }
}

