/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.teradata.functions;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.plugin.teradata.functions.TeradataFunctionsPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTeradataFunctions
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.functionAssertions.installPlugin((Plugin)new TeradataFunctionsPlugin());
    }

    @Test
    public void testIndex() {
        this.assertFunction("INDEX('high', 'ig')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("INDEX('high', 'igx')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("INDEX('Quadratically', 'a')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("INDEX('foobar', 'foobar')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("INDEX('foobar', 'foobar_baz')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("INDEX('foobar', 'obar')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("INDEX('zoo!', '!')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("INDEX('x', '')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("INDEX('', '')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("INDEX(NULL, '')", (Type)BigintType.BIGINT, null);
        this.assertFunction("INDEX('', NULL)", (Type)BigintType.BIGINT, null);
        this.assertFunction("INDEX(NULL, NULL)", (Type)BigintType.BIGINT, null);
    }

    @Test
    public void testChar2HexInt() {
        this.assertFunction("CHAR2HEXINT('123')", (Type)VarcharType.VARCHAR, "003100320033");
        this.assertFunction("CHAR2HEXINT('One Ring')", (Type)VarcharType.VARCHAR, "004F006E0065002000520069006E0067");
    }

    @Test
    public void testChar2HexIntUtf8() {
        this.assertFunction("CHAR2HEXINT('\u0105')", (Type)VarcharType.VARCHAR, "0105");
        this.assertFunction("CHAR2HEXINT('\u0ca0')", (Type)VarcharType.VARCHAR, "0CA0");
        this.assertFunction("CHAR2HEXINT('\uff71')", (Type)VarcharType.VARCHAR, "FF71");
        this.assertFunction("CHAR2HEXINT('\u0ca0\u76ca\u0ca0')", (Type)VarcharType.VARCHAR, "0CA076CA0CA0");
        this.assertFunction("CHAR2HEXINT('(\u30ce\u0ca0\u76ca\u0ca0)\u30ce\u5f61\u253b\u2501\u253b')", (Type)VarcharType.VARCHAR, "002830CE0CA076CA0CA0002930CE5F61253B2501253B");
    }
}

