/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.teradata.functions.dateformat;

import io.trino.plugin.teradata.functions.dateformat.DateFormatParser;
import io.trino.spi.TrinoException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDateFormatParser {
    @Test
    public void testTokenize() {
        Assert.assertEquals((Collection)DateFormatParser.tokenize((String)"yyyy mm").stream().map(Token::getType).collect(Collectors.toList()), Arrays.asList(7, 9, 4));
    }

    @Test
    public void testGreedinessLongFirst() {
        Assert.assertEquals((int)1, (int)DateFormatParser.tokenize((String)"yy").size());
        Assert.assertEquals((int)1, (int)DateFormatParser.tokenize((String)"yyyy").size());
        Assert.assertEquals((int)2, (int)DateFormatParser.tokenize((String)"yyyyyy").size());
    }

    @Test
    public void testInvalidTokenTokenize() {
        Assert.assertEquals((Collection)DateFormatParser.tokenize((String)"ala").stream().map(Token::getType).collect(Collectors.toList()), Arrays.asList(10, 10, 10));
    }

    @Test(expectedExceptions={TrinoException.class})
    public void testInvalidTokenCreate1() {
        DateFormatParser.createDateTimeFormatter((String)"ala");
    }

    @Test(expectedExceptions={TrinoException.class})
    public void testInvalidTokenCreate2() {
        DateFormatParser.createDateTimeFormatter((String)"yyym/mm/dd");
    }

    @Test
    public void testCreateDateTimeFormatter() {
        DateTimeFormatter formatter = DateFormatParser.createDateTimeFormatter((String)"yyyy/mm/dd");
        Assert.assertEquals((Object)formatter.parseDateTime("1988/04/08"), (Object)new DateTime(1988, 4, 8, 0, 0));
    }
}

