/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.SortedProperties;
import org.nuiton.version.Version;
import org.nuiton.version.Versions;

public class I18nDefinitionFile
implements Closeable {
    private static final Log log = LogFactory.getLog(I18nDefinitionFile.class);
    private static final String ENTRY_VERSION = "version";
    private static final String ENTRY_ENCODING = "encoding";
    private static final String ENTRY_LOCALES = "locales";
    private static final String ENTRY_TEMPLATE_EXTENSION = "template.extension";
    private static final String ENTRY_TEMPLATE_LIST = "template.list";
    private static final String ENTRY_BUNDLE_PREFIX = "bundles.";
    private static final String SUFFIX_DEFINITION_PROPERTIES = "-definition.properties";
    private String urlPrefix;
    private final String name;
    private Charset encoding = StandardCharsets.UTF_8;
    private final Version version;
    private final Set<Locale> locales;
    private final String templateExtension;
    private final Set<String> templateList;
    private final Multimap<Locale, String> bundles;
    private final Map<String, Properties> propertiesCache;
    private final Map<String, String> contentCache;
    private HashMultimap<Locale, String> translationKeys;

    public I18nDefinitionFile(String name, Charset encoding, Version version, Set<Locale> locales, String templateExtension, Set<String> templateList, Multimap<Locale, String> bundles) {
        this.name = name;
        this.encoding = encoding;
        this.version = version;
        this.locales = locales;
        this.templateExtension = templateExtension;
        this.templateList = templateList;
        this.bundles = bundles;
        this.propertiesCache = new TreeMap<String, Properties>();
        this.contentCache = new TreeMap<String, String>();
    }

    public I18nDefinitionFile(URL url) throws IOException, NullPointerException {
        Objects.requireNonNull(url);
        this.propertiesCache = new TreeMap<String, Properties>();
        this.contentCache = new TreeMap<String, String>();
        InputStream inputStream = url.openStream();
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Url [%s] does not exists.", url));
        }
        String i18nBundleUrlPrefix = url.toString().replace(SUFFIX_DEFINITION_PROPERTIES, "");
        this.name = i18nBundleUrlPrefix.substring(url.toString().lastIndexOf("/") + 1);
        this.urlPrefix = i18nBundleUrlPrefix.substring(0, url.toString().lastIndexOf("/") + 1);
        Properties i18nProperties = this.loadProperties(url);
        this.encoding = Charset.forName(i18nProperties.getProperty(ENTRY_ENCODING));
        this.version = Versions.valueOf((String)i18nProperties.getProperty(ENTRY_VERSION));
        this.templateExtension = i18nProperties.getProperty(ENTRY_TEMPLATE_EXTENSION);
        String templatesListStr = i18nProperties.getProperty(ENTRY_TEMPLATE_LIST);
        ImmutableSet.Builder templateNamesBuilder = ImmutableSet.builder();
        if (templatesListStr != null) {
            for (String templateName : templatesListStr.split(",")) {
                templateNamesBuilder.add((Object)templateName.trim());
            }
        }
        this.templateList = templateNamesBuilder.build();
        ImmutableSet.Builder localesBuilder = ImmutableSet.builder();
        this.bundles = ArrayListMultimap.create();
        for (String localeStr : ((String)i18nProperties.get(ENTRY_LOCALES)).split(",")) {
            String[] split = localeStr.split("_");
            Locale locale = new Locale(split[0], split[1]);
            localesBuilder.add((Object)locale);
            String bundleList = (String)i18nProperties.get(ENTRY_BUNDLE_PREFIX + locale.getLanguage() + "_" + locale.getCountry());
            for (String bundle : bundleList.split(",")) {
                this.bundles.put((Object)locale, (Object)bundle.trim());
            }
        }
        this.locales = localesBuilder.build();
    }

    public URL getDefinitionFileURL() {
        return this.url(this.urlPrefix + this.name + SUFFIX_DEFINITION_PROPERTIES);
    }

    public URL getMainBundleURL(Locale locale) {
        return this.url(this.urlPrefix + String.format("%s_%s_%s.properties", this.name, locale.getLanguage(), locale.getCountry()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<URL> getTemplateURL(String templateName, Locale locale) {
        URL url = this.url(this.urlPrefix + String.format("%s/%s_%s.%s", this.templateExtension, templateName, locale.getLanguage(), this.templateExtension));
        try (InputStream inputStream = url.openStream();){
            if (inputStream == null) {
                url = null;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return Optional.ofNullable(url);
    }

    public URL getBundleURL(String bundleName) {
        return this.getClass().getClassLoader().getResource(bundleName);
    }

    private URL url(String suffix) {
        try {
            return new URL(suffix);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    private Properties loadProperties(URL url) {
        Objects.requireNonNull(url);
        return this.propertiesCache.computeIfAbsent(url.toString(), u -> {
            log.info((Object)("Loading " + url));
            Properties p = new Properties();
            try (InputStreamReader inputStream = new InputStreamReader(url.openStream(), this.encoding);){
                p.load(inputStream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't load properties at: " + url, e);
            }
            return p;
        });
    }

    private String loadContent(URL url) {
        Objects.requireNonNull(url);
        return this.contentCache.computeIfAbsent(url.toString(), u -> {
            log.info((Object)("Loading " + url));
            try {
                return IOUtils.toString((URL)url, (Charset)this.encoding);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't load properties at: " + url, e);
            }
        });
    }

    public void store(File directory) throws IOException {
        Joiner joiner = Joiner.on((String)",");
        SortedProperties p = new SortedProperties();
        p.put(ENTRY_VERSION, this.version.toString());
        p.put(ENTRY_ENCODING, this.encoding.toString());
        p.put(ENTRY_LOCALES, joiner.join(this.locales));
        if (this.templateExtension != null) {
            p.put(ENTRY_TEMPLATE_EXTENSION, this.templateExtension);
        }
        if (CollectionUtils.isNotEmpty(this.templateList)) {
            p.put(ENTRY_TEMPLATE_LIST, joiner.join(this.templateList));
        }
        for (Locale locale : this.locales) {
            p.put(ENTRY_BUNDLE_PREFIX + locale.getLanguage() + "_" + locale.getCountry(), joiner.join((Iterable)this.bundles.get((Object)locale)));
        }
        Path target = directory.toPath().resolve(String.format("%s%s", this.name, SUFFIX_DEFINITION_PROPERTIES));
        log.info((Object)("Store definition file to " + target));
        try (BufferedWriter writer = Files.newBufferedWriter(target, new OpenOption[0]);){
            p.store(writer, "Generated by " + this.getClass().getName() + " at " + new Date());
        }
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public Set<Locale> getLocales() {
        return this.locales;
    }

    public String getTemplateExtension() {
        return this.templateExtension;
    }

    public Set<String> getTemplateList() {
        return this.templateList;
    }

    public Properties getMainBundle(Locale locale) {
        return this.loadProperties(this.getMainBundleURL(locale));
    }

    public HashMultimap<Locale, String> getTranslationKeys() {
        if (this.translationKeys == null) {
            this.translationKeys = HashMultimap.create();
            for (Locale locale : this.locales) {
                Properties properties = this.loadProperties(this.getMainBundleURL(locale));
                properties.keySet().forEach(o -> {
                    this.translationKeys.put(null, (Object)((String)o));
                    this.translationKeys.put((Object)locale, (Object)((String)o));
                });
            }
        }
        return this.translationKeys;
    }

    public Multimap<Locale, String> getBundles() {
        return this.bundles;
    }

    public String getTemplateContent(String templateName, Locale locale) {
        return this.getTemplateURL(templateName, locale).map(this::loadContent).orElse(null);
    }

    @Override
    public void close() {
        this.contentCache.clear();
        this.propertiesCache.clear();
        this.translationKeys = null;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public String getMainBundleFilename(Locale locale) {
        return String.format("%s_%s_%s.properties", this.getName(), locale.getLanguage(), locale.getCountry());
    }

    public String getTemplateFilename(Locale locale, String templateName) {
        return String.format("%s/%s_%s.%s", this.getTemplateExtension(), templateName, locale.getLanguage(), this.getTemplateExtension());
    }

    public Properties getBundle(String bundleName) {
        return this.loadProperties(this.getBundleURL(bundleName));
    }
}

