/*
 * #%L
 * I18n :: Api
 * %%
 * Copyright (C) 2004 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.i18n.format;

import java.util.Formatter;
import java.util.Locale;

/**
 * Implementation of {@link I18nMessageFormatter} based on {@link Formatter}
 * syntax.
 * <p>
 * <strong>Note: </strong> This is the default message formatter used by
 * i18n system.
 *
 * @see Formatter
 * @see String#format(Locale, String, Object...)
 * @since 2.4
 */
public class StringFormatI18nMessageFormatter implements I18nMessageFormatter {

    @Override
    public String format(Locale locale, String message, Object... args) {
        String result;

        if (args.length == 0) {

            // keep the same behavior than before version 2.3 : no format will
            // be done if no arguments are present
            result = message;
        } else {

            // do format with given locale, message and arguments
            result = String.format(locale, message, args);
        }
        return result;
    }
}
