package org.nuiton.topia.service.migration;

/*-
 * #%L
 * ToPIA Extension :: Migration service
 * %%
 * Copyright (C) 2018 - 2019 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaMisconfigurationException;
import org.nuiton.topia.persistence.support.TopiaSqlDllSupport;
import org.nuiton.version.Version;
import org.nuiton.version.Versions;

import java.util.Iterator;
import java.util.ServiceLoader;

/**
 * Configuration of the {@link TopiaMigrationService} service.
 * <p>
 * Created by tchemit on 05/05/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class TopiaMigrationServiceConfiguration {

    private static final Logger log = LogManager.getLogger(TopiaMigrationServiceConfiguration.class);

    /**
     * User callback.
     */
    protected final TopiaMigrationServiceAskUserToMigrate callback;
    /**
     * Topia application context
     */
    protected final TopiaApplicationContext applicationContext;
    /**
     * Persistence model version (the version to migrate to).
     */
    protected final Version modelVersion;
    /**
     * Migration classifier.
     */
    protected final String classifier;

    protected TopiaMigrationServiceConfiguration(TopiaApplicationContext applicationContext, TopiaMigrationServiceAskUserToMigrate callback, String classifier) {
        this.applicationContext = applicationContext;
        this.callback = callback;
        this.modelVersion = Versions.valueOf(applicationContext.getModelVersion());
        this.classifier = classifier;
    }

    public static TopiaMigrationServiceConfiguration of(TopiaApplicationContext applicationContext) {

        String classifier = TopiaSqlDllSupport.getClassifier(applicationContext);
        if (classifier != null) {
            log.debug("Use Classifier          - " + classifier);
        }

        TopiaMigrationServiceAskUserToMigrate askUserToMigrate = null;
        Iterator<TopiaMigrationServiceAskUserToMigrate> serviceIterator = ServiceLoader.load(TopiaMigrationServiceAskUserToMigrate.class).iterator();
        if (serviceIterator.hasNext()) {

            askUserToMigrate = serviceIterator.next();
            if (serviceIterator.hasNext()) {
                throw new TopiaMisconfigurationException("More than one service registred for type: " + TopiaMigrationServiceAskUserToMigrate.class.getName(), applicationContext.getConfiguration());
            }
        }
        if (askUserToMigrate != null) {
            log.debug("Use callback            - " + askUserToMigrate);
        }
        return new TopiaMigrationServiceConfiguration(applicationContext, askUserToMigrate, classifier);
    }

    public TopiaMigrationServiceAskUserToMigrate getCallback() {
        return callback;
    }

    public TopiaApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public Version getModelVersion() {
        return modelVersion;
    }

    public String getClassifier() {
        return classifier;
    }
}
