/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.migration;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaMisconfigurationException;
import org.nuiton.topia.persistence.support.TopiaSqlDllSupport;
import org.nuiton.topia.service.migration.TopiaMigrationServiceAskUserToMigrate;
import org.nuiton.version.Version;
import org.nuiton.version.Versions;

public class TopiaMigrationServiceConfiguration {
    private static final Logger log = LogManager.getLogger(TopiaMigrationServiceConfiguration.class);
    protected final TopiaMigrationServiceAskUserToMigrate callback;
    protected final TopiaApplicationContext applicationContext;
    protected final Version modelVersion;
    protected final String classifier;

    protected TopiaMigrationServiceConfiguration(TopiaApplicationContext applicationContext, TopiaMigrationServiceAskUserToMigrate callback, String classifier) {
        this.applicationContext = applicationContext;
        this.callback = callback;
        this.modelVersion = Versions.valueOf((String)applicationContext.getModelVersion());
        this.classifier = classifier;
    }

    public static TopiaMigrationServiceConfiguration of(TopiaApplicationContext applicationContext) {
        String classifier = TopiaSqlDllSupport.getClassifier((TopiaApplicationContext)applicationContext);
        if (classifier != null) {
            log.debug("Use Classifier          - " + classifier);
        }
        TopiaMigrationServiceAskUserToMigrate askUserToMigrate = null;
        Iterator<TopiaMigrationServiceAskUserToMigrate> serviceIterator = ServiceLoader.load(TopiaMigrationServiceAskUserToMigrate.class).iterator();
        if (serviceIterator.hasNext()) {
            askUserToMigrate = serviceIterator.next();
            if (serviceIterator.hasNext()) {
                throw new TopiaMisconfigurationException("More than one service registred for type: " + TopiaMigrationServiceAskUserToMigrate.class.getName(), applicationContext.getConfiguration());
            }
        }
        if (askUserToMigrate != null) {
            log.debug("Use callback            - " + askUserToMigrate);
        }
        return new TopiaMigrationServiceConfiguration(applicationContext, askUserToMigrate, classifier);
    }

    public TopiaMigrationServiceAskUserToMigrate getCallback() {
        return this.callback;
    }

    public TopiaApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Version getModelVersion() {
        return this.modelVersion;
    }

    public String getClassifier() {
        return this.classifier;
    }
}

