/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.migration.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.topia.persistence.TopiaMigrationServiceException;
import org.nuiton.topia.service.migration.resources.MigrationVersionResource;
import org.nuiton.version.Version;
import org.nuiton.version.VersionComparator;

public class MigrationVersionResourceProvider {
    private static final Logger log = LogManager.getLogger(MigrationVersionResourceProvider.class);
    private static MigrationVersionResourceProvider INSTANCE;
    protected final Map<Version, MigrationVersionResource> resources;

    protected MigrationVersionResourceProvider() {
        ImmutableMap.Builder resourcesBuilder = ImmutableMap.builder();
        for (MigrationVersionResource resource : ServiceLoader.load(MigrationVersionResource.class)) {
            resourcesBuilder.put((Object)resource.getVersion(), (Object)resource);
        }
        this.resources = resourcesBuilder.build();
        log.info(String.format("Found %d migration resource(s).", this.resources.size()));
    }

    public static synchronized MigrationVersionResourceProvider get() {
        return INSTANCE == null ? (INSTANCE = new MigrationVersionResourceProvider()) : INSTANCE;
    }

    public List<Version> getAvailableVersions() {
        return this.resources.keySet().stream().sorted(new VersionComparator()).collect(Collectors.toList());
    }

    public Version getLastVersion() {
        List<Version> values = this.getAvailableVersions();
        return values.isEmpty() ? null : values.get(values.size() - 1);
    }

    public ImmutableList<Version> getVersionsAfter(Version current) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Version version : this.getAvailableVersions()) {
            if (!version.after(current)) continue;
            builder.add((Object)version);
        }
        return builder.build();
    }

    public MigrationVersionResource getResource(Version version) {
        MigrationVersionResource result = this.resources.get(version);
        if (result == null) {
            throw new TopiaMigrationServiceException(String.format("Can't find resource for version: %s.", version));
        }
        return result;
    }
}

