/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.migration.resources;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.topia.persistence.support.TopiaSqlQuery;
import org.nuiton.topia.service.migration.resources.DefaultMigrationVersionResourceScriptLayout;
import org.nuiton.topia.service.migration.resources.MigrationVersionResourceExecutor;
import org.nuiton.topia.service.migration.resources.MigrationVersionResourceScriptLayout;
import org.nuiton.version.Version;

public abstract class MigrationVersionResource {
    private final Version version;
    private final boolean requiresFinalize;
    private final MigrationVersionResourceScriptLayout scriptLayout;
    private Map<String, String> scriptVariables;

    public MigrationVersionResource(Version version) {
        this(version, false);
    }

    public MigrationVersionResource(Version version, boolean requiresFinalize) {
        this(version, new DefaultMigrationVersionResourceScriptLayout(), requiresFinalize);
    }

    public MigrationVersionResource(Version version, MigrationVersionResourceScriptLayout scriptLayout, boolean requiresFinalize) {
        this.version = Objects.requireNonNull(version);
        this.scriptLayout = scriptLayout;
        this.requiresFinalize = requiresFinalize;
    }

    public abstract void generateSqlScript(MigrationVersionResourceExecutor var1) throws IOException;

    public void generateFinalizeSqlScript(MigrationVersionResourceExecutor executor) throws IOException {
    }

    public Version getVersion() {
        return this.version;
    }

    public MigrationVersionResourceScriptLayout getScriptLayout() {
        return this.scriptLayout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationVersionResource that = (MigrationVersionResource)o;
        return Objects.equals(this.version, that.version);
    }

    public boolean requiresFinalize() {
        return this.requiresFinalize;
    }

    public Map<String, String> getScriptVariables() {
        return this.scriptVariables;
    }

    public void setScriptVariables(Map<String, String> scriptVariables) {
        this.scriptVariables = scriptVariables;
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    protected void migrateIdx(MigrationVersionResourceExecutor executor, String schemaName, String mainTable, String field) {
        List<Pair<String, String>> result = executor.findMultipleResult(new MigrateIdxSqlQuery(schemaName, mainTable, field));
        String currentId = null;
        int position = 0;
        for (Pair<String, String> pair : result) {
            String parentId = (String)pair.getLeft();
            if (!parentId.equals(currentId)) {
                position = 0;
                currentId = parentId;
            }
            String id = (String)pair.getRight();
            executor.writeSql(String.format("UPDATE %s.%s SET %s_idx = %d WHERE topiaId = '%s';", schemaName, mainTable, field, position++, id));
        }
    }

    protected static class MigrateIdxSqlQuery
    extends TopiaSqlQuery<Pair<String, String>> {
        private final String schemaName;
        private final String mainTable;
        private final String field;

        private MigrateIdxSqlQuery(String schemaName, String mainTable, String field) {
            this.schemaName = schemaName;
            this.mainTable = mainTable;
            this.field = field;
        }

        public PreparedStatement prepareQuery(Connection connection) throws SQLException {
            return connection.prepareStatement(String.format("select %s, topiaId FROM %s.%s order by %s, topiaCreateDate", this.field, this.schemaName, this.mainTable, this.field));
        }

        public Pair<String, String> prepareResult(ResultSet resultSet) throws SQLException {
            return Pair.of((Object)resultSet.getString(1), (Object)resultSet.getString(2));
        }
    }
}

