/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.migration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaMisconfigurationException;
import org.nuiton.topia.persistence.support.TopiaSqlDllSupport;
import org.nuiton.topia.service.migration.TopiaMigrationServiceAskUserToMigrate;
import org.nuiton.version.Version;
import org.nuiton.version.Versions;

public class TopiaMigrationServiceConfiguration {
    private static final Logger log = LogManager.getLogger(TopiaMigrationServiceConfiguration.class);
    protected final TopiaMigrationServiceAskUserToMigrate callback;
    protected final TopiaApplicationContext applicationContext;
    protected final Version modelVersion;
    protected final String classifier;
    protected final Path temporaryDirectory;

    protected TopiaMigrationServiceConfiguration(TopiaApplicationContext applicationContext, TopiaMigrationServiceAskUserToMigrate callback, String classifier, Path temporaryDirectory) {
        this.applicationContext = applicationContext;
        this.callback = callback;
        this.modelVersion = Versions.valueOf((String)applicationContext.getModelVersion());
        this.classifier = classifier;
        this.temporaryDirectory = temporaryDirectory;
    }

    public static TopiaMigrationServiceConfiguration of(TopiaApplicationContext applicationContext, Map<String, String> serviceConfiguration) {
        String path;
        String classifier = TopiaSqlDllSupport.getClassifier((TopiaApplicationContext)applicationContext);
        if (classifier != null) {
            log.debug("Use Classifier          - " + classifier);
        }
        TopiaMigrationServiceAskUserToMigrate askUserToMigrate = null;
        Iterator<TopiaMigrationServiceAskUserToMigrate> serviceIterator = ServiceLoader.load(TopiaMigrationServiceAskUserToMigrate.class).iterator();
        if (serviceIterator.hasNext()) {
            askUserToMigrate = serviceIterator.next();
            if (serviceIterator.hasNext()) {
                throw new TopiaMisconfigurationException("More than one service registered for type: " + TopiaMigrationServiceAskUserToMigrate.class.getName(), applicationContext.getConfiguration());
            }
        }
        if (askUserToMigrate != null) {
            log.debug("Use callback            - " + askUserToMigrate);
        }
        if ((path = serviceConfiguration.get("java.io.tmpdir")) == null) {
            path = System.getProperty("java.io.tmpdir");
        }
        Path temporaryDirectory = Paths.get(path, new String[0]);
        try {
            if (Files.notExists(temporaryDirectory, new LinkOption[0])) {
                Files.createDirectories(temporaryDirectory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new TopiaException("Could not create temporary directory: " + temporaryDirectory, (Throwable)e);
        }
        return new TopiaMigrationServiceConfiguration(applicationContext, askUserToMigrate, classifier, temporaryDirectory);
    }

    public TopiaMigrationServiceAskUserToMigrate getCallback() {
        return this.callback;
    }

    public TopiaApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Version getModelVersion() {
        return this.modelVersion;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public Path getTemporaryDirectory() {
        return this.temporaryDirectory;
    }
}

