/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.migration.version;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;
import org.nuiton.topia.persistence.internal.HibernateProvider;
import org.nuiton.topia.persistence.jdbc.JdbcConfiguration;
import org.nuiton.topia.persistence.jdbc.JdbcHelper;
import org.nuiton.topia.persistence.util.TopiaUtil;
import org.nuiton.topia.service.migration.version.TMSVersion;

public class TMSVersionHibernateDao {
    public static final String TABLE_NAME = "tms_version";
    private static final Logger log = LogManager.getLogger(TMSVersionHibernateDao.class);
    private final Configuration hibernateConfiguration;
    private final String tableName;
    private final JdbcHelper jdbcHelper;
    private final HibernateProvider hibernateProvider;

    public TMSVersionHibernateDao(TopiaApplicationContext topiaApplicationContext) {
        TopiaConfiguration topiaConfiguration = topiaApplicationContext.getConfiguration();
        this.hibernateProvider = ((AbstractTopiaApplicationContext)topiaApplicationContext).getHibernateProvider();
        this.jdbcHelper = new JdbcHelper((JdbcConfiguration)topiaConfiguration);
        Properties prop = new Properties();
        prop.put("hibernate.connection.url", topiaConfiguration.getJdbcConnectionUrl());
        prop.put("hibernate.connection.username", topiaConfiguration.getJdbcConnectionUser());
        prop.put("hibernate.connection.password", topiaConfiguration.getJdbcConnectionPassword());
        prop.put("hibernate.connection.driver_class", topiaConfiguration.getJdbcDriverClass().getName());
        prop.put("hibernate.dialect", HibernateProvider.getHibernateDialect((TopiaConfiguration)topiaConfiguration));
        prop.putAll((Map<?, ?>)topiaConfiguration.getHibernateExtraConfiguration());
        this.hibernateConfiguration = new Configuration();
        this.hibernateConfiguration.setProperties(prop);
        this.hibernateConfiguration.addClass(TMSVersion.class);
        this.hibernateConfiguration.getProperties().remove("hibernate.hbm2ddl.auto");
        String schemaName = TopiaUtil.getSchemaName((Configuration)this.hibernateConfiguration);
        this.tableName = (String)(schemaName == null ? "" : schemaName + ".") + TABLE_NAME;
    }

    public void save(String version) {
        try {
            this.jdbcHelper.runUpdate(String.format("DELETE FROM %1$s; INSERT INTO %1$s (version) VALUES('%2$s')", this.tableName, version));
        }
        catch (Exception e) {
            throw new TopiaException(String.format("Could not save version %s", version), (Throwable)e);
        }
    }

    public Optional<TMSVersion> getVersion() {
        return TMSVersionHibernateDao.getVersion(this.jdbcHelper, this.tableName);
    }

    public static Optional<TMSVersion> getVersion(JdbcHelper jdbcHelper, String tableName) {
        try {
            String version = jdbcHelper.runSelectOnString(String.format("select version from %s", tableName));
            return Optional.ofNullable(version == null ? null : new TMSVersion(version));
        }
        catch (Exception e) {
            throw new TopiaException("Could not obtain version", (Throwable)e);
        }
    }

    public boolean isTableExists() {
        try (SessionFactory sessionFactory = this.newSessionFactory();){
            Metadata metaData = this.hibernateProvider.newMetaData(this.hibernateConfiguration, sessionFactory, Collections.singleton(TMSVersion.class));
            boolean bl = TopiaUtil.isSchemaExist((Configuration)this.hibernateConfiguration, (Metadata)metaData, (String)TMSVersion.class.getName());
            return bl;
        }
    }

    public void createSchemaIfNotExist() {
        try (SessionFactory sessionFactory = this.newSessionFactory();){
            Metadata metaData = this.hibernateProvider.newMetaData(this.hibernateConfiguration, sessionFactory, Collections.singleton(TMSVersion.class));
            this.createSchemaIfNotExist(metaData);
        }
    }

    public SessionFactory newSessionFactory() {
        return TopiaUtil.newSessionFactory((Configuration)this.hibernateConfiguration);
    }

    private void createTMSSchema(Metadata metadata) {
        SchemaExport schemaExport = new SchemaExport();
        EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
        if (log.isDebugEnabled()) {
            targetTypes.add(TargetType.STDOUT);
        }
        schemaExport.create(targetTypes, metadata);
    }

    private void createSchemaIfNotExist(Metadata metaData) {
        if (TopiaUtil.isSchemaEmpty((Configuration)this.hibernateConfiguration, (Metadata)metaData)) {
            this.createTMSSchema(metaData);
        }
    }
}

