/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.migration;

import com.google.common.collect.ImmutableList;
import io.ultreia.java4all.util.TimeLog;
import io.ultreia.java4all.util.Version;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaMigrationServiceException;
import org.nuiton.topia.service.migration.TopiaMigrationServiceAskUserToMigrate;
import org.nuiton.topia.service.migration.TopiaMigrationServiceConfiguration;
import org.nuiton.topia.service.migration.TopiaMigrationServiceContext;

public class TopiaMigrationService
implements org.nuiton.topia.persistence.TopiaMigrationService {
    private static final TimeLog TIME_LOG = new TimeLog(TopiaMigrationService.class, 100L, 1000L);
    private static final Logger log = LogManager.getLogger(TopiaMigrationService.class);
    protected TopiaMigrationServiceConfiguration configuration;
    protected TopiaMigrationServiceContext context;

    public String getSchemaVersion() throws TopiaMigrationServiceException {
        return this.getContext().getDbVersion().getVersion();
    }

    public void initOnCreateSchema() throws TopiaMigrationServiceException {
        this.getContext().createSchemaIfNotExist();
        this.getContext().saveModelVersion();
    }

    public void runSchemaMigration() throws TopiaMigrationServiceException {
        TopiaMigrationServiceContext context = this.getContext();
        Version modelVersion = context.getModelVersion();
        Version dbVersion = context.getDbVersion();
        boolean dbNotVersioned = context.isDbNotVersioned();
        boolean versionTableExist = context.isVersionTableExist();
        log.info(String.format("Starting Topia Migration Service  - Model version : %s, Database version : %s", modelVersion, dbVersion));
        log.debug(String.format("Is db not versioned ?     = %s", dbNotVersioned));
        log.debug(String.format("TMSVersion exists         = %s", versionTableExist));
        if (!versionTableExist) {
            context.createSchemaIfNotExist();
        }
        if (versionTableExist && dbVersion.equals((Object)modelVersion)) {
            log.info("Database is up to date, no migration needed.");
            return;
        }
        if (versionTableExist && dbNotVersioned) {
            log.info("Database is empty, no migration needed.");
            context.saveModelVersion();
            return;
        }
        List<Version> allVersions = context.getResources().getAvailableVersions();
        log.info(String.format("Available versions: %1$s", allVersions));
        ImmutableList<Version> versionsToApply = context.getResources().getVersionsAfter(dbVersion);
        if (versionsToApply.isEmpty()) {
            log.info("No version to apply, no migration needed.");
            context.saveModelVersion();
            return;
        }
        log.info(String.format("Versions to apply: %1$s", versionsToApply));
        Optional<TopiaMigrationServiceAskUserToMigrate> askUserToMigrate = context.getAskUserToMigrate();
        boolean performMigration = askUserToMigrate.map(c -> c.canIMigrate(dbVersion, (List<Version>)versionsToApply)).orElse(true);
        log.debug("Handler choose : " + performMigration);
        if (!performMigration) {
            return;
        }
        long statementCount = 0L;
        for (Version version : versionsToApply) {
            long t0 = TimeLog.getTime();
            long versionCount = this.migrateVersion(context, version);
            statementCount += versionCount;
            TIME_LOG.log(t0, "migrationVersion", version.toString() + " - " + versionCount + " sql statements");
        }
        log.info(String.format("Ends migration - db version: %s - consume %d sql statement(s)", context.getDbVersion(), statementCount));
    }

    public void initTopiaService(TopiaApplicationContext topiaApplicationContext, Map<String, String> serviceConfiguration) {
        this.configuration = TopiaMigrationServiceConfiguration.of(Objects.requireNonNull(topiaApplicationContext), serviceConfiguration);
    }

    public void close() {
        this.context = null;
    }

    /*
     * Exception decompiling
     */
    protected long migrateVersion(TopiaMigrationServiceContext context, Version version) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createSchemaIfNotExist() {
        this.getContext().createSchemaIfNotExist();
    }

    public TopiaMigrationServiceContext getContext() {
        return this.context == null ? (this.context = TopiaMigrationServiceContext.of(this.configuration)) : this.context;
    }
}

