/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.migration;

import io.ultreia.java4all.util.Version;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.SessionFactory;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.topia.service.migration.TopiaMigrationServiceAskUserToMigrate;
import org.nuiton.topia.service.migration.TopiaMigrationServiceConfiguration;
import org.nuiton.topia.service.migration.TopiaMigrationServiceExecutor;
import org.nuiton.topia.service.migration.resources.MigrationVersionResource;
import org.nuiton.topia.service.migration.resources.MigrationVersionResourceProvider;
import org.nuiton.topia.service.migration.version.TMSVersion;
import org.nuiton.topia.service.migration.version.TMSVersionHibernateDao;

public class TopiaMigrationServiceContext {
    private static final Logger log = LogManager.getLogger(TopiaMigrationServiceContext.class);
    protected final TopiaMigrationServiceConfiguration configuration;
    protected final TMSVersionHibernateDao dao;
    protected final MigrationVersionResourceProvider resources;
    protected final boolean dbNotVersioned;
    protected final Path scriptPath;
    protected boolean versionTableExist;
    protected Version dbVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TopiaMigrationServiceContext of(TopiaMigrationServiceConfiguration configuration) {
        boolean versionTableExist;
        TMSVersionHibernateDao dao;
        Version v;
        boolean dbNotVersioned;
        block10: {
            block9: {
                TopiaApplicationContext<?> topiaApplicationContext = configuration.getApplicationContext();
                dbNotVersioned = false;
                v = null;
                dao = new TMSVersionHibernateDao(topiaApplicationContext);
                try {
                    versionTableExist = dao.isTableExists();
                    if (versionTableExist) {
                        Optional<TMSVersion> tmsVersion = dao.getVersion();
                        if (tmsVersion.isPresent()) {
                            v = tmsVersion.get().toVersion();
                        }
                        if (v == null) {
                            log.warn(String.format("Version not found on table %s", "tms_version"));
                        }
                    } else if (topiaApplicationContext.getConfiguration().isInitSchema()) {
                        dao.createSchemaIfNotExist();
                    }
                    if (v != null) break block9;
                    v = Version.VZERO;
                    dbNotVersioned = true;
                }
                catch (Throwable throwable) {
                    if (v == null) {
                        v = Version.VZERO;
                        dbNotVersioned = true;
                        log.info("Database version not found, so database schema is considered as V0");
                    } else {
                        log.info(String.format("Detected database version: %s", v));
                    }
                    Version dbVersion = v;
                    throw throwable;
                }
                log.info("Database version not found, so database schema is considered as V0");
                break block10;
            }
            log.info(String.format("Detected database version: %s", v));
        }
        Version dbVersion = v;
        return new TopiaMigrationServiceContext(configuration, versionTableExist, dbNotVersioned, dbVersion, MigrationVersionResourceProvider.get(), dao);
    }

    protected TopiaMigrationServiceContext(TopiaMigrationServiceConfiguration configuration, boolean versionTableExist, boolean dbNotVersioned, Version dbVersion, MigrationVersionResourceProvider resources, TMSVersionHibernateDao dao) {
        this.configuration = configuration;
        this.versionTableExist = versionTableExist;
        this.dbNotVersioned = dbNotVersioned;
        this.dbVersion = dbVersion;
        this.resources = resources;
        this.dao = dao;
        try {
            this.scriptPath = Files.createTempDirectory(configuration.getTemporaryDirectory(), "topia-migration-service", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't create scripts path", e);
        }
    }

    public Path getScriptPath() {
        return this.scriptPath;
    }

    public boolean isVersionTableExist() {
        return this.versionTableExist;
    }

    public boolean isDbNotVersioned() {
        return this.dbNotVersioned;
    }

    public Version getModelVersion() {
        return this.configuration.getModelVersion();
    }

    public Version getDbVersion() {
        return this.dbVersion;
    }

    public MigrationVersionResourceProvider getResources() {
        return this.resources;
    }

    public void createSchemaIfNotExist() {
        this.dao.createSchemaIfNotExist();
        this.versionTableExist = true;
    }

    public void saveModelVersion() {
        this.saveVersion(this.getModelVersion());
    }

    public Optional<TopiaMigrationServiceAskUserToMigrate> getAskUserToMigrate() {
        return Optional.ofNullable(this.configuration.getCallback());
    }

    protected void saveVersion(Version version) {
        log.info(String.format("[ Version %s ] Saving new database version.", version));
        this.dao.save(version.getVersion());
        this.dbVersion = version;
    }

    public SessionFactory newSessionFactory() {
        return this.dao.newSessionFactory();
    }

    public MigrationVersionResource getResource(Version version) {
        return this.resources.getResource(version);
    }

    public TopiaMigrationServiceExecutor newExecutor(MigrationVersionResource migrationVersionResource, TopiaSqlSupport sqlSupport) {
        return new TopiaMigrationServiceExecutor(migrationVersionResource.getVersion(), migrationVersionResource.getScriptLayout(), sqlSupport, this.configuration.getClassifier(), this.getScriptPath(), migrationVersionResource.getScriptVariables());
    }
}

