/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.migration;

import io.ultreia.java4all.util.Version;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.support.H2TopiaSqlDllSupportImpl;
import org.nuiton.topia.persistence.internal.support.PGTopiaSqlDllSupportImpl;
import org.nuiton.topia.persistence.script.SqlScriptReader;
import org.nuiton.topia.persistence.script.SqlScriptWriter;
import org.nuiton.topia.persistence.support.TopiaSqlDllSupport;
import org.nuiton.topia.persistence.support.TopiaSqlDllSupportProvider;
import org.nuiton.topia.persistence.support.TopiaSqlQuery;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.topia.persistence.support.TopiaSqlWork;
import org.nuiton.topia.service.migration.resources.MigrationVersionResource;
import org.nuiton.topia.service.migration.resources.MigrationVersionResourceExecutor;
import org.nuiton.topia.service.migration.resources.MigrationVersionResourceScriptLayout;

public class TopiaMigrationServiceExecutor
implements MigrationVersionResourceExecutor {
    private static final Logger log = LogManager.getLogger(TopiaMigrationServiceExecutor.class);
    protected final Version version;
    protected final TopiaSqlSupport sqlSupport;
    protected final TopiaSqlDllSupport sqlDllSupport;
    protected final MigrationVersionResourceScriptLayout scriptLayout;
    protected final String classifier;
    protected final Path scriptForVersion;
    protected final SqlScriptWriter writer;
    protected final String logPrefix;
    private final Map<String, String> scriptVariables;
    private final ClassLoader classLoader;

    protected TopiaMigrationServiceExecutor(MigrationVersionResource migrationVersionResource, TopiaSqlSupport sqlSupport, String classifier, Path scriptsPath, Map<String, String> scriptVariables) {
        this.version = Objects.requireNonNull(Objects.requireNonNull(migrationVersionResource).getVersion());
        this.scriptLayout = Objects.requireNonNull(migrationVersionResource.getScriptLayout());
        this.classLoader = Objects.requireNonNull(migrationVersionResource.getClassLoader());
        this.classifier = Objects.requireNonNull(classifier);
        this.sqlSupport = Objects.requireNonNull(sqlSupport);
        this.sqlDllSupport = (TopiaSqlDllSupport)TopiaSqlDllSupportProvider.get().get(classifier).orElseThrow(() -> new IllegalStateException("No TopiaSqlDllSupport for classifier: " + classifier));
        this.scriptVariables = scriptVariables;
        this.scriptForVersion = Objects.requireNonNull(scriptsPath).resolve(String.format("migration-version-%s.sql", this.version));
        this.writer = SqlScriptWriter.of((Path)this.scriptForVersion);
        this.logPrefix = String.format("[ Version %s ] ", this.version);
        log.info(this.logPrefix + String.format("Will produce sql script at: %s", this.scriptForVersion));
    }

    protected TopiaMigrationServiceExecutor(TopiaMigrationServiceExecutor parent, Path scriptForVersion) {
        this.classLoader = Objects.requireNonNull(Objects.requireNonNull(parent).classLoader);
        this.version = Objects.requireNonNull(parent.version);
        this.scriptLayout = Objects.requireNonNull(parent.scriptLayout);
        this.classifier = Objects.requireNonNull(parent.classifier);
        this.sqlSupport = Objects.requireNonNull(parent.sqlSupport);
        this.sqlDllSupport = Objects.requireNonNull(parent.sqlDllSupport);
        this.scriptForVersion = Objects.requireNonNull(scriptForVersion);
        this.writer = SqlScriptWriter.of((Path)scriptForVersion);
        this.scriptVariables = parent.scriptVariables;
        this.logPrefix = Objects.requireNonNull(parent.logPrefix);
        log.info(this.logPrefix + String.format("Will produce sql script at: %s", scriptForVersion));
    }

    public TopiaMigrationServiceExecutor toFinalize() {
        Path scriptPath = this.scriptForVersion.getParent().resolve(this.scriptForVersion.toFile().getName().replace(".sql", "-finalize.sql"));
        return new TopiaMigrationServiceExecutor(this, scriptPath);
    }

    public String getLogPrefix() {
        return this.logPrefix;
    }

    public Path getScriptForVersion() {
        return this.scriptForVersion;
    }

    @Override
    public void writeSql(String sql) {
        this.writer.writeSql(sql);
    }

    @Override
    public void addScript(String rank, String prefix) {
        this.loadScript(this.version, rank, prefix);
    }

    @Override
    public <O> O findSingleResult(TopiaSqlQuery<O> query) {
        return (O)this.sqlSupport.findSingleResult(query);
    }

    @Override
    public <O> List<O> findMultipleResult(TopiaSqlQuery<O> query) {
        return this.sqlSupport.findMultipleResult(query);
    }

    @Override
    public <O> Set<O> findMultipleResultAstSet(TopiaSqlQuery<O> query) {
        return new LinkedHashSet<O>(this.findMultipleResult(query));
    }

    @Override
    public void dropSchema(String schemaName) {
        this.writeSql(this.sqlDllSupport.dropSchema(this.sqlSupport, schemaName));
    }

    @Override
    public void dropTable(String schemaName, String tableName) {
        this.writeSql(this.sqlDllSupport.dropTable(this.sqlSupport, schemaName, tableName));
    }

    @Override
    public void doSqlWork(TopiaSqlWork sqlWork) {
        this.sqlSupport.doSqlWork(sqlWork);
    }

    @Override
    public Set<String> getTopiaIds(String tableName) {
        return TopiaSqlDllSupport.selectAllAsSet((TopiaSqlSupport)this.sqlSupport, (String)String.format("SELECT topiaId FROM %s;", tableName));
    }

    @Override
    public String getUniqueConstraintName(String tableName, String columnName) {
        return this.sqlDllSupport.getUniqueConstraintName(this.sqlSupport, tableName, columnName);
    }

    @Override
    public String getFirstTableUniqueConstraintName(String tableName) {
        return this.sqlDllSupport.getFirstTableUniqueConstraintName(this.sqlSupport, tableName);
    }

    @Override
    public Set<String> getConstraintNames(String tableName) {
        return this.sqlDllSupport.getConstraintNames(this.sqlSupport, tableName);
    }

    @Override
    public Set<String> getForeignKeyConstraintNames(String tableName) {
        return this.sqlDllSupport.getForeignKeyConstraintNames(this.sqlSupport, tableName);
    }

    @Override
    public String getForeignKeyConstraintName(String schemaName, String tableName, String columnName, boolean mustExists) {
        return this.sqlDllSupport.getForeignKeyConstraintName(this.sqlSupport, schemaName, tableName, columnName, mustExists);
    }

    @Override
    public Set<String> getUniqueKeyConstraintNames(String tableName) {
        return this.sqlDllSupport.getUniqueKeyConstraintNames(this.sqlSupport, tableName);
    }

    @Override
    public void removeFK(String tableName) {
        this.sqlDllSupport.removeFK(this.sqlSupport, tableName).forEach(this::writeSql);
    }

    @Override
    public void removeFK(String schemaName, String tableName, String columnName) {
        String sql = this.sqlDllSupport.removeFK(this.sqlSupport, schemaName, tableName, columnName);
        this.writeSql(sql);
    }

    @Override
    public void removeFKIfExists(String schemaName, String tableName, String columnName) {
        this.sqlDllSupport.removeFKIfExists(this.sqlSupport, schemaName, tableName, columnName).ifPresent(this::writeSql);
    }

    @Override
    public void removePKIfExists(String schemaName, String tableName) {
        this.sqlDllSupport.removePKIfExists(this.sqlSupport, schemaName, tableName).ifPresent(this::writeSql);
    }

    @Override
    public void removeUK(String tableName) {
        this.sqlDllSupport.removeUK(this.sqlSupport, tableName).forEach(this::writeSql);
    }

    @Override
    public void executeForPG(Consumer<MigrationVersionResourceExecutor> consumer) {
        if (this.isPG()) {
            consumer.accept(this);
        }
    }

    @Override
    public void executeForH2(Consumer<MigrationVersionResourceExecutor> consumer) {
        if (this.isH2()) {
            consumer.accept(this);
        }
    }

    public long flush() throws IOException {
        this.writer.flush();
        return this.writer.getStatementCount();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    protected void loadScript(Version version, String rank, String prefix) {
        URL scriptLocation = this.getScriptLocation(version, rank, prefix, this.classifier);
        log.info(String.format("%sLoad migration script: %s", this.logPrefix, scriptLocation));
        try (SqlScriptReader scriptReader = SqlScriptReader.builder((URL)scriptLocation).setvariables(this.scriptVariables).build();){
            for (String statement : scriptReader) {
                this.writer.writeSql(statement);
            }
        }
        catch (IOException e) {
            throw new TopiaException("Could not load migration script: " + scriptLocation, (Throwable)e);
        }
    }

    protected URL getScriptLocation(Version version, String rank, String prefix, String classifier) {
        String scriptPath = this.scriptLayout.getScriptPath(version, rank, prefix, "common");
        URL scriptLocation = this.getResource(scriptPath);
        if (scriptLocation == null) {
            scriptPath = this.scriptLayout.getScriptPath(version, rank, prefix, classifier);
            scriptLocation = this.getResource(scriptPath);
        }
        Objects.requireNonNull(scriptLocation, "Can't find script " + scriptPath + ", nor his common version.");
        return scriptLocation;
    }

    protected URL getResource(String scriptPath) {
        return this.classLoader.getResource(scriptPath.substring(1));
    }

    protected boolean isH2() {
        return H2TopiaSqlDllSupportImpl.CLASSIFIER.equals(this.classifier);
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected boolean isPG() {
        return PGTopiaSqlDllSupportImpl.CLASSIFIER.equals(this.classifier);
    }
}

