/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.migration.resources;

import io.ultreia.java4all.util.Version;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.nuiton.topia.persistence.support.TopiaSqlQuery;
import org.nuiton.topia.service.migration.resources.DefaultMigrationVersionResourceScriptLayout;
import org.nuiton.topia.service.migration.resources.MigrationVersionResourceExecutor;
import org.nuiton.topia.service.migration.resources.MigrationVersionResourceScriptLayout;

public abstract class MigrationVersionResource {
    private static boolean FOR_TCK = false;
    private static ClassLoader CLASS_LOADER;
    private final Version version;
    private final boolean requiresFinalize;
    private final MigrationVersionResourceScriptLayout scriptLayout;
    private final ClassLoader classLoader;
    private Map<String, String> scriptVariables;

    public static void setClassLoader(ClassLoader classLoader) {
        CLASS_LOADER = classLoader;
    }

    public static void setForTck(boolean forTck) {
        FOR_TCK = forTck;
    }

    protected static boolean isForTck() {
        return FOR_TCK;
    }

    public MigrationVersionResource(Version version) {
        this(version, false);
    }

    public MigrationVersionResource(Version version, boolean requiresFinalize) {
        this(version, new DefaultMigrationVersionResourceScriptLayout(), requiresFinalize);
    }

    public MigrationVersionResource(Version version, MigrationVersionResourceScriptLayout scriptLayout, boolean requiresFinalize) {
        this.version = Objects.requireNonNull(version);
        this.scriptLayout = scriptLayout;
        this.requiresFinalize = requiresFinalize;
        this.classLoader = CLASS_LOADER == null ? this.getClass().getClassLoader() : CLASS_LOADER;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public abstract void generateSqlScript(MigrationVersionResourceExecutor var1) throws IOException;

    public void generateFinalizeSqlScript(MigrationVersionResourceExecutor executor) throws IOException {
    }

    public Version getVersion() {
        return this.version;
    }

    public MigrationVersionResourceScriptLayout getScriptLayout() {
        return this.scriptLayout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationVersionResource that = (MigrationVersionResource)o;
        return Objects.equals(this.version, that.version);
    }

    public boolean requiresFinalize() {
        return this.requiresFinalize;
    }

    public Map<String, String> getScriptVariables() {
        return this.scriptVariables;
    }

    public void setScriptVariables(Map<String, String> scriptVariables) {
        this.scriptVariables = scriptVariables;
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    protected void migrateIdx(MigrationVersionResourceExecutor executor, String schemaName, String mainTable, String field) {
        List<Map.Entry<String, String>> result = executor.findMultipleResult(new MigrateIdxSqlQuery(schemaName, mainTable, field));
        String currentId = null;
        int position = 0;
        for (Map.Entry<String, String> pair : result) {
            String parentId = pair.getKey();
            if (!parentId.equals(currentId)) {
                position = 0;
                currentId = parentId;
            }
            String id = pair.getValue();
            executor.writeSql(String.format("UPDATE %s.%s SET %s_idx = %d WHERE topiaId = '%s';", schemaName, mainTable, field, position++, id));
        }
    }

    protected static class MigrateIdxSqlQuery
    extends TopiaSqlQuery<Map.Entry<String, String>> {
        private final String schemaName;
        private final String mainTable;
        private final String field;

        private MigrateIdxSqlQuery(String schemaName, String mainTable, String field) {
            this.schemaName = schemaName;
            this.mainTable = mainTable;
            this.field = field;
        }

        public PreparedStatement prepareQuery(Connection connection) throws SQLException {
            return connection.prepareStatement(String.format("select %s, topiaId FROM %s.%s order by %s, topiaCreateDate", this.field, this.schemaName, this.mainTable, this.field));
        }

        public Map.Entry<String, String> prepareResult(ResultSet resultSet) throws SQLException {
            return new AbstractMap.SimpleEntry<String, String>(resultSet.getString(1), resultSet.getString(2));
        }
    }
}

