/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.migration.resources;

import io.ultreia.java4all.util.Version;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.topia.persistence.TopiaMigrationServiceException;
import org.nuiton.topia.service.migration.resources.MigrationVersionResource;

public class MigrationVersionResourceProvider {
    private static final Logger log = LogManager.getLogger(MigrationVersionResourceProvider.class);
    private static MigrationVersionResourceProvider INSTANCE;
    protected final Map<Version, MigrationVersionResource> resources;

    public static synchronized MigrationVersionResourceProvider get() {
        return INSTANCE == null ? (INSTANCE = new MigrationVersionResourceProvider()) : INSTANCE;
    }

    protected MigrationVersionResourceProvider() {
        LinkedHashMap<Version, MigrationVersionResource> resourcesBuilder = new LinkedHashMap<Version, MigrationVersionResource>();
        for (MigrationVersionResource resource : ServiceLoader.load(MigrationVersionResource.class)) {
            resourcesBuilder.put(resource.getVersion(), resource);
        }
        this.resources = Collections.unmodifiableMap(resourcesBuilder);
        log.info(String.format("Found %d migration resource(s).", this.resources.size()));
    }

    public List<Version> getAvailableVersions() {
        return this.resources.keySet().stream().sorted(new Version.VersionComparator()).collect(Collectors.toList());
    }

    public Version getLastVersion() {
        List<Version> values = this.getAvailableVersions();
        return values.isEmpty() ? null : values.get(values.size() - 1);
    }

    public List<Version> getVersionsAfter(Version current) {
        LinkedList<Version> builder = new LinkedList<Version>();
        for (Version version : this.getAvailableVersions()) {
            if (!version.after(current)) continue;
            builder.add(version);
        }
        return Collections.unmodifiableList(builder);
    }

    public MigrationVersionResource getResource(Version version) {
        MigrationVersionResource result = this.resources.get(version);
        if (result == null) {
            throw new TopiaMigrationServiceException(String.format("Can't find resource for version: %s.", version));
        }
        return result;
    }
}

