/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.cli;

import java.util.ArrayList;
import java.util.List;
import org.dynjs.Config;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class Arguments {
    static final String CONSOLE = "--console";
    static final String HELP = "--help";
    static final String VERSION = "--version";
    static final String DEBUG = "--debug";
    static final String FILE = "--file";
    @Option(name="--console", usage="Opens a REPL console to test small expressions.")
    private boolean console;
    @Option(name="--help", usage="Shows current screen. Running without parameters also shows this.")
    private boolean help;
    @Option(name="--version", usage="Shows current dynjs version.")
    private boolean version;
    @Option(name="--debug", usage="Run REPL in debug mode.")
    private boolean debug;
    @Argument(usage="File to be executed by dynjs", required=false, metaVar="FILE")
    private List<String> arguments = new ArrayList<String>();

    public Config getConfig() {
        Config config = new Config();
        if (this.isDebug()) {
            config.setDebug(true);
        }
        config.setArgv(this.arguments.toArray());
        return config;
    }

    public boolean isEmpty() {
        return !this.console && !this.help && !this.version && !this.debug && this.arguments.isEmpty();
    }

    public boolean isConsole() {
        return this.console;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isVersion() {
        return this.version;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getFilename() {
        if (this.arguments.size() > 0) {
            return this.arguments.get(0);
        }
        return null;
    }
}

