/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.dynjs.exception.DynJSException;
import org.dynjs.runtime.DynJS;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.ConsoleOutput;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.reader.ConsoleInputSession;
import org.jboss.aesh.console.settings.QuitHandler;
import org.jboss.aesh.console.settings.Settings;

public class Repl {
    public static final String WELCOME_MESSAGE = "dynjs console." + System.lineSeparator() + "Type exit and press ENTER to leave." + System.lineSeparator();
    public static final String PROMPT = "dynjs> ";
    private final DynJS runtime;
    private final OutputStream out;
    private final InputStream in;
    private final String welcome;
    private final String prompt;
    private PrintWriter log;

    public Repl(DynJS runtime, InputStream in, OutputStream out) {
        this(runtime, in, out, WELCOME_MESSAGE, PROMPT);
    }

    public Repl(DynJS runtime, InputStream in, OutputStream out, String welcome, String prompt) {
        this(runtime, in, out, welcome, prompt, System.getProperty("user.dir") + "/dynjs.log");
    }

    public Repl(DynJS runtime, InputStream in, OutputStream out, String welcome, String prompt, String log) {
        this.prompt = prompt;
        this.welcome = welcome;
        this.runtime = runtime;
        this.out = out;
        this.in = new ConsoleInputSession(in).getExternalInputStream();
        try {
            this.log = new PrintWriter(log);
        }
        catch (IOException e) {
            System.err.println("Cannot create error log " + log);
        }
    }

    public void run() {
        try {
            Settings consoleSettings = Settings.getInstance();
            consoleSettings.setStdOut(this.out);
            consoleSettings.setInputStream(this.in);
            consoleSettings.setHistoryPersistent(false);
            consoleSettings.enableOperatorParser(false);
            consoleSettings.setQuitHandler(new QuitHandler(){

                public void quit() {
                    if (Repl.this.log != null) {
                        Repl.this.log.close();
                    }
                }
            });
            final Console console = Console.getInstance();
            console.pushToStdOut(this.welcome);
            console.setPrompt(new Prompt(this.prompt));
            console.setConsoleCallback(new ConsoleCallback(){

                public int readConsoleOutput(ConsoleOutput consoleOutput) throws IOException {
                    String statement = consoleOutput.getBuffer();
                    Repl.this.log.write(statement + "\n");
                    if (statement.equalsIgnoreCase("exit")) {
                        console.stop();
                        return 0;
                    }
                    try {
                        Object object = Repl.this.runtime.evaluate(statement);
                        Repl.this.log.write(object.toString() + "\n");
                        console.pushToStdOut(object.toString() + "\n");
                    }
                    catch (DynJSException e) {
                        console.pushToStdErr(e.getLocalizedMessage() + "\n");
                        Repl.this.logException(e);
                    }
                    catch (IncompatibleClassChangeError e) {
                        console.pushToStdErr("ERROR> " + e.getLocalizedMessage() + "\n");
                        console.pushToStdErr("Error parsing statement: " + statement + "\n");
                        Repl.this.logException(e);
                    }
                    catch (Exception e) {
                        e.printStackTrace(new PrintWriter(Repl.this.out));
                        Repl.this.logException(e);
                    }
                    return 0;
                }
            });
            console.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void logException(Throwable e) {
        this.log.write(e.getLocalizedMessage() + "\n");
        e.printStackTrace(this.log);
        this.log.write("\n");
    }
}

