/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.codegen;

import java.io.PrintStream;
import me.qmx.jitescript.CodeBlock;
import me.qmx.jitescript.util.CodegenUtils;
import org.dynjs.compiler.JSCompiler;
import org.dynjs.exception.ThrowException;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.AdditiveExpression;
import org.dynjs.parser.ast.BlockStatement;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.BasicBlock;
import org.dynjs.runtime.BlockManager;
import org.dynjs.runtime.Completion;
import org.dynjs.runtime.ExecutionContext;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.Reference;
import org.dynjs.runtime.Types;
import org.dynjs.runtime.interp.InterpretedBasicBlock;
import org.dynjs.runtime.interp.InterpretingVisitorFactory;
import org.objectweb.asm.tree.LabelNode;

public abstract class CodeGeneratingVisitor
extends CodeBlock
implements CodeVisitor {
    private InterpretingVisitorFactory interpFactory;
    private BlockManager blockManager;

    public CodeGeneratingVisitor(InterpretingVisitorFactory interpFactory, BlockManager blockManager) {
        this.interpFactory = interpFactory;
        this.blockManager = blockManager;
    }

    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    protected void emitDebug(String message) {
        this.ldc(message);
        this.aprintln();
        this.pop();
    }

    protected void emitTop() {
        this.aprintln();
    }

    public CodeBlock aprintln() {
        this.dup();
        this.getstatic(CodegenUtils.p(System.class), "err", CodegenUtils.ci(PrintStream.class));
        this.swap();
        this.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, (Class[])CodegenUtils.params((Class[])new Class[]{Object.class})));
        return this;
    }

    @Override
    public void visit(ExecutionContext context, AdditiveExpression expr, boolean strict) {
        if (expr.getOp().equals("+")) {
            this.visitPlus(context, expr, strict);
        } else {
            this.visitMinus(context, expr, strict);
        }
    }

    public abstract void visitPlus(ExecutionContext var1, AdditiveExpression var2, boolean var3);

    public abstract void visitMinus(ExecutionContext var1, AdditiveExpression var2, boolean var3);

    public CodeBlock jsCheckObjectCoercible(String debug) {
        CodeBlock codeBlock = new CodeBlock().dup().aload(1).swap();
        if (debug != null) {
            codeBlock.ldc((Object)debug);
        } else {
            codeBlock.aconst_null();
        }
        codeBlock.invokestatic(CodegenUtils.p(Types.class), "checkObjectCoercible", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{ExecutionContext.class, Object.class, String.class}));
        return codeBlock;
    }

    public CodeBlock jsResolve(String identifier) {
        return new CodeBlock().aload(1).ldc((Object)identifier).invokevirtual(CodegenUtils.p(ExecutionContext.class), "resolve", CodegenUtils.sig(Reference.class, (Class[])new Class[]{String.class}));
    }

    public CodeBlock jsPushUndefined() {
        return new CodeBlock().getstatic(CodegenUtils.p(Types.class), "UNDEFINED", CodegenUtils.ci(Types.Undefined.class));
    }

    public CodeBlock jsPushNull() {
        return new CodeBlock().getstatic(CodegenUtils.p(Types.class), "NULL", CodegenUtils.ci(Types.Null.class));
    }

    public CodeBlock jsToPrimitive() {
        return new CodeBlock().aload(1).dup_x2().pop().invokestatic(CodegenUtils.p(Types.class), "toPrimitive", CodegenUtils.sig(Object.class, (Class[])new Class[]{ExecutionContext.class, Object.class, String.class}));
    }

    public CodeBlock jsToNumber() {
        return new CodeBlock().aload(1).swap().invokestatic(CodegenUtils.p(Types.class), "toNumber", CodegenUtils.sig(Number.class, (Class[])new Class[]{ExecutionContext.class, Object.class}));
    }

    public CodeBlock jsToBoolean() {
        return new CodeBlock().invokestatic(CodegenUtils.p(Types.class), "toBoolean", CodegenUtils.sig(Boolean.class, (Class[])new Class[]{Object.class}));
    }

    public CodeBlock jsToInt32() {
        return new CodeBlock().aload(1).swap().invokestatic(CodegenUtils.p(Types.class), "toInt32", CodegenUtils.sig(Long.class, (Class[])new Class[]{ExecutionContext.class, Object.class}));
    }

    public CodeBlock jsToUint32() {
        return new CodeBlock().aload(1).swap().invokestatic(CodegenUtils.p(Types.class), "toUint32", CodegenUtils.sig(Long.class, (Class[])new Class[]{ExecutionContext.class, Object.class}));
    }

    public CodeBlock jsToObject() {
        return new CodeBlock().aload(1).swap().invokestatic(CodegenUtils.p(Types.class), "toObject", CodegenUtils.sig(JSObject.class, (Class[])new Class[]{ExecutionContext.class, Object.class}));
    }

    public CodeBlock jsGetValue() {
        return this.jsGetValue(null);
    }

    public abstract CodeBlock jsGetValue(Class<?> var1);

    public CodeBlock jsGetBase() {
        return new CodeBlock().invokevirtual(CodegenUtils.p(Reference.class), "getBase", CodegenUtils.sig(Object.class, (Class[])new Class[0]));
    }

    public CodeBlock jsToString() {
        return new CodeBlock().aload(1).swap().invokestatic(CodegenUtils.p(Types.class), "toString", CodegenUtils.sig(String.class, (Class[])new Class[]{ExecutionContext.class, Object.class}));
    }

    public CodeBlock jsCreatePropertyReference() {
        return new CodeBlock().invokevirtual(CodegenUtils.p(ExecutionContext.class), "createPropertyReference", CodegenUtils.sig(Reference.class, (Class[])new Class[]{Object.class, String.class}));
    }

    public CodeBlock jsThrowTypeError(String message) {
        return new CodeBlock().newobj(CodegenUtils.p(ThrowException.class)).dup().aload(1).ldc((Object)message).invokevirtual(CodegenUtils.p(ExecutionContext.class), "createTypeError", CodegenUtils.sig(JSObject.class, (Class[])new Class[]{String.class})).aload(1).swap().invokespecial(CodegenUtils.p(ThrowException.class), "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{ExecutionContext.class, Object.class})).athrow();
    }

    public CodeBlock jsThrowReferenceError(String message) {
        return new CodeBlock().newobj(CodegenUtils.p(ThrowException.class)).dup().aload(1).ldc((Object)message).invokevirtual(CodegenUtils.p(ExecutionContext.class), "createReferenceError", CodegenUtils.sig(JSObject.class, (Class[])new Class[]{String.class})).aload(1).swap().invokespecial(CodegenUtils.p(ThrowException.class), "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{ExecutionContext.class, Object.class})).athrow();
    }

    public CodeBlock jsThrowSyntaxError(String message) {
        return new CodeBlock().newobj(CodegenUtils.p(ThrowException.class)).dup().aload(1).ldc((Object)message).invokevirtual(CodegenUtils.p(ExecutionContext.class), "createSyntaxError", CodegenUtils.sig(JSObject.class, (Class[])new Class[]{String.class})).aload(1).swap().invokespecial(CodegenUtils.p(ThrowException.class), "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{ExecutionContext.class, Object.class})).athrow();
    }

    public CodeBlock ifEitherIsDouble(LabelNode target) {
        return new CodeBlock().checkcast(CodegenUtils.p(Number.class)).swap().checkcast(CodegenUtils.p(Number.class)).swap().dup().instance_of(CodegenUtils.p(Double.class)).iftrue(target).swap().dup_x1().instance_of(CodegenUtils.p(Double.class)).iftrue(target);
    }

    public CodeBlock ifEitherIsNaN(LabelNode target) {
        return new CodeBlock().checkcast(CodegenUtils.p(Number.class)).dup_x1().swap().checkcast(CodegenUtils.p(Number.class)).dup_x2().swap().invokestatic(CodegenUtils.p(CodeGeneratingVisitor.class), "isEitherNaN", CodegenUtils.sig(Boolean.TYPE, (Class[])new Class[]{Number.class, Number.class})).iftrue(target);
    }

    public CodeBlock ifTopIsZero(LabelNode target) {
        return new CodeBlock().checkcast(CodegenUtils.p(Number.class)).dup().invokestatic(CodegenUtils.p(CodeGeneratingVisitor.class), "isZero", CodegenUtils.sig(Boolean.TYPE, (Class[])new Class[]{Number.class})).iftrue(target);
    }

    public static boolean isEitherNaN(Number lhs, Number rhs) {
        return Double.isNaN(lhs.doubleValue()) || Double.isNaN(rhs.doubleValue());
    }

    public static boolean isZero(Number num) {
        return num.doubleValue() == 0.0;
    }

    public CodeBlock ifBothAreString(LabelNode target) {
        LabelNode end = new LabelNode();
        return new CodeBlock().dup().instance_of(CodegenUtils.p(String.class)).iffalse(end).swap().dup_x1().instance_of(CodegenUtils.p(String.class)).iftrue(target).label(end);
    }

    public CodeBlock convertTopTwoToPrimitiveLongs() {
        return new CodeBlock().invokevirtual(CodegenUtils.p(Number.class), "longValue", CodegenUtils.sig(Long.TYPE, (Class[])new Class[0])).dup2_x1().pop2().invokevirtual(CodegenUtils.p(Number.class), "longValue", CodegenUtils.sig(Long.TYPE, (Class[])new Class[0])).dup2_x2().pop2();
    }

    public CodeBlock convertTopToLong() {
        return new CodeBlock().invokestatic(CodegenUtils.p(Long.class), "valueOf", CodegenUtils.sig(Long.class, (Class[])new Class[]{Long.TYPE}));
    }

    public CodeBlock convertTopToInteger() {
        return new CodeBlock().invokestatic(CodegenUtils.p(Integer.class), "valueOf", CodegenUtils.sig(Integer.class, (Class[])new Class[]{Integer.TYPE}));
    }

    public CodeBlock convertTopTwoToPrimitiveDoubles() {
        return new CodeBlock().checkcast(CodegenUtils.p(Number.class)).swap().checkcast(CodegenUtils.p(Number.class)).swap().invokevirtual(CodegenUtils.p(Number.class), "doubleValue", CodegenUtils.sig(Double.TYPE, (Class[])new Class[0])).dup2_x1().pop2().invokevirtual(CodegenUtils.p(Number.class), "doubleValue", CodegenUtils.sig(Double.TYPE, (Class[])new Class[0])).swap2();
    }

    public CodeBlock convertTopToDouble() {
        return new CodeBlock().invokestatic(CodegenUtils.p(Double.class), "valueOf", CodegenUtils.sig(Double.class, (Class[])new Class[]{Double.TYPE}));
    }

    public CodeBlock jsCompletionValue() {
        return new CodeBlock().getfield(CodegenUtils.p(Completion.class), "value", CodegenUtils.ci(Object.class));
    }

    public CodeBlock handleCompletion(LabelNode normalTarget, LabelNode breakTarget, LabelNode continueTarget, LabelNode returnTarget) {
        return new CodeBlock().append(this.jsCompletionType()).lookupswitch(normalTarget, new int[]{Completion.Type.NORMAL.ordinal(), Completion.Type.BREAK.ordinal(), Completion.Type.CONTINUE.ordinal(), Completion.Type.RETURN.ordinal()}, new LabelNode[]{normalTarget, breakTarget, continueTarget, returnTarget});
    }

    public CodeBlock jsCompletionTarget() {
        return new CodeBlock().getfield(CodegenUtils.p(Completion.class), "target", CodegenUtils.ci(String.class));
    }

    public CodeBlock jsCompletionType() {
        return new CodeBlock().getfield(CodegenUtils.p(Completion.class), "type", CodegenUtils.ci(Completion.Type.class)).invokevirtual(CodegenUtils.p(Completion.Type.class), "ordinal", CodegenUtils.sig(Integer.TYPE, (Class[])new Class[0]));
    }

    public void breakCompletion(String target) {
        if (target == null) {
            this.aconst_null();
        } else {
            this.ldc(target);
        }
        this.invokestatic(CodegenUtils.p(Completion.class), "createBreak", CodegenUtils.sig(Completion.class, (Class[])new Class[]{String.class}));
    }

    public void continueCompletion(String target) {
        if (target == null) {
            this.aconst_null();
        } else {
            this.ldc(target);
        }
        this.invokestatic(CodegenUtils.p(Completion.class), "createContinue", CodegenUtils.sig(Completion.class, (Class[])new Class[]{String.class}));
    }

    public void normalCompletion() {
        this.invokestatic(CodegenUtils.p(Completion.class), "createNormal", CodegenUtils.sig(Completion.class, (Class[])new Class[0]));
    }

    public void normalCompletionWithValue() {
        this.invokestatic(CodegenUtils.p(Completion.class), "createNormal", CodegenUtils.sig(Completion.class, (Class[])new Class[]{Object.class}));
    }

    public void returnCompletion() {
        this.invokestatic(CodegenUtils.p(Completion.class), "createReturn", CodegenUtils.sig(Completion.class, (Class[])new Class[]{Object.class}));
    }

    public void convertToNormalCompletion() {
        this.dup();
        this.getstatic(CodegenUtils.p(Completion.Type.class), "NORMAL", CodegenUtils.ci(Completion.Type.class));
        this.putfield(CodegenUtils.p(Completion.class), "type", CodegenUtils.ci(Completion.Type.class));
    }

    public static void injectLineNumber(CodeBlock block, Statement statement) {
        Position position = statement.getPosition();
        if (position != null) {
            LabelNode lineLabel = new LabelNode();
            block.line(position.getLine(), lineLabel);
            block.label(lineLabel);
        }
    }

    public void invokeCompiledStatementBlock(String grist, Statement block, boolean strict) {
        this.compiledStatementBlock(grist, block, strict);
        this.aload(1);
        this.invokeinterface(CodegenUtils.p(BasicBlock.class), "call", CodegenUtils.sig(Completion.class, (Class[])new Class[]{ExecutionContext.class}));
    }

    public void compiledStatementBlock(String grist, Statement block, boolean strict) {
        int statementNumber = block.getStatementNumber();
        BlockManager.Entry entry = this.blockManager.retrieve(statementNumber);
        if (entry.statement == null) {
            entry.statement = block;
        }
        this.aload(1);
        this.ldc(statementNumber);
        this.invokevirtual(CodegenUtils.p(ExecutionContext.class), "retrieveBlockEntry", CodegenUtils.sig(BlockManager.Entry.class, (Class[])new Class[]{Integer.TYPE}));
        this.aload(1);
        this.invokevirtual(CodegenUtils.p(ExecutionContext.class), "getCompiler", CodegenUtils.sig(JSCompiler.class, (Class[])new Class[0]));
        this.swap();
        this.aload(1);
        this.swap();
        this.ldc(grist);
        this.swap();
        this.getfield(CodegenUtils.p(BlockManager.Entry.class), "statement", CodegenUtils.ci(Statement.class));
        if (strict) {
            this.iconst_1();
        } else {
            this.iconst_0();
        }
        this.invokevirtual(CodegenUtils.p(JSCompiler.class), "compileBasicBlock", CodegenUtils.sig(BasicBlock.class, (Class[])new Class[]{ExecutionContext.class, String.class, Statement.class, Boolean.TYPE}));
    }

    public void compiledFunction(String identifier, String[] formalParams, Statement block, boolean strict) {
        int statementNumber = block.getStatementNumber();
        BlockManager.Entry entry = this.blockManager.retrieve(statementNumber);
        if (entry.statement == null) {
            entry.statement = block;
        }
        this.aload(1);
        this.ldc(statementNumber);
        this.invokevirtual(CodegenUtils.p(ExecutionContext.class), "retrieveBlockEntry", CodegenUtils.sig(BlockManager.Entry.class, (Class[])new Class[]{Integer.TYPE}));
        this.aload(1);
        this.invokevirtual(CodegenUtils.p(ExecutionContext.class), "getCompiler", CodegenUtils.sig(JSCompiler.class, (Class[])new Class[0]));
        this.swap();
        this.getfield(CodegenUtils.p(BlockManager.Entry.class), "statement", CodegenUtils.ci(Statement.class));
        this.aload(1);
        this.swap();
        if (identifier != null) {
            this.ldc(identifier);
        } else {
            this.aconst_null();
        }
        this.swap();
        this.checkcast(CodegenUtils.p(BlockStatement.class));
        this.bipush(formalParams.length);
        this.anewarray(CodegenUtils.p(String.class));
        for (int i = 0; i < formalParams.length; ++i) {
            this.dup();
            this.bipush(i);
            this.ldc(formalParams[i]);
            this.aastore();
        }
        this.swap();
        if (strict) {
            this.iconst_1();
        } else {
            this.iconst_0();
        }
        this.invokevirtual(CodegenUtils.p(JSCompiler.class), "compileFunction", CodegenUtils.sig(JSFunction.class, (Class[])new Class[]{ExecutionContext.class, String.class, String[].class, Statement.class, Boolean.TYPE}));
    }

    void interpretedStatement(Statement statement, boolean strict) {
        BlockManager.Entry entry = this.getBlockManager().retrieve(statement.getStatementNumber());
        InterpretedBasicBlock interpreted = new InterpretedBasicBlock(this.interpFactory, statement, strict);
        entry.setCompiled(interpreted);
        this.aload(1);
        this.ldc(statement.getStatementNumber());
        this.invokevirtual(CodegenUtils.p(ExecutionContext.class), "retrieveBlockEntry", CodegenUtils.sig(BlockManager.Entry.class, (Class[])new Class[]{Integer.TYPE}));
        this.invokevirtual(CodegenUtils.p(BlockManager.Entry.class), "getCompiled", CodegenUtils.sig(BasicBlock.class, (Class[])new Class[0]));
        this.aload(1);
        this.invokeinterface(CodegenUtils.p(BasicBlock.class), "call", CodegenUtils.sig(Completion.class, (Class[])new Class[]{ExecutionContext.class}));
    }

    public static interface Arities {
        public static final int THIS = 0;
        public static final int EXECUTION_CONTEXT = 1;
        public static final int COMPLETION = 2;
    }
}

