/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.compiler.bytecode;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.qmx.jitescript.CodeBlock;
import me.qmx.jitescript.JiteClass;
import me.qmx.jitescript.util.CodegenUtils;
import org.dynjs.Config;
import org.dynjs.codegen.CodeGeneratingVisitorFactory;
import org.dynjs.compiler.BasicBlockCompiler;
import org.dynjs.compiler.bytecode.AbstractBytecodeCompiler;
import org.dynjs.compiler.bytecode.BytecodeBasicBlock;
import org.dynjs.compiler.bytecode.partial.CompilationPlanner;
import org.dynjs.compiler.bytecode.partial.PartialCompiler;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.BlockStatement;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.BasicBlock;
import org.dynjs.runtime.BlockManager;
import org.dynjs.runtime.ExecutionContext;

public class BytecodeBasicBlockCompiler
extends AbstractBytecodeCompiler
implements BasicBlockCompiler {
    private AtomicInteger counter = new AtomicInteger();

    public BytecodeBasicBlockCompiler(Config config, CodeGeneratingVisitorFactory factory) {
        super(config, factory);
    }

    @Override
    public BasicBlock compile(ExecutionContext context, String grist, Statement body, boolean strict) {
        int statementNumber = body.getStatementNumber();
        BlockManager.Entry entry = context.getBlockManager().retrieve(statementNumber);
        BasicBlock code = entry.getCompiled();
        if (code instanceof BytecodeBasicBlock) {
            return code;
        }
        String className = this.nextClassName(grist);
        JiteClass cls = new JiteClass(className, CodegenUtils.p(BytecodeBasicBlock.class), new String[0]);
        cls.defineMethod("<init>", 1, CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{String.class, Boolean.TYPE, List.class, List.class}), new CodeBlock().aload(0).aload(1).iload(2).aload(3).aload(4).invokespecial(CodegenUtils.p(BytecodeBasicBlock.class), "<init>", CodegenUtils.sig(Void.TYPE, (Class[])new Class[]{String.class, Boolean.TYPE, List.class, List.class})).aload(0).invokevirtual(cls.getClassName().replace('.', '/'), "initializeCode", CodegenUtils.sig(Void.TYPE, (Class[])new Class[0])).voidreturn());
        CompilationPlanner planner = new CompilationPlanner(this.getConfig(), context.getClassLoader(), this.getFactory());
        PartialCompiler compiler = null;
        compiler = body instanceof BlockStatement ? planner.plan((BlockStatement)body) : planner.plan(new BlockStatement(Collections.singletonList(body)));
        compiler.define(cls, context, false);
        Class blockClass = (Class)this.defineClass(context.getClassLoader(), cls);
        Position position = body.getPosition();
        String fileName = position != null ? position.getFileName() : "eval";
        try {
            Constructor ctor = blockClass.getDeclaredConstructor(String.class, Boolean.TYPE, List.class, List.class);
            BasicBlock block = (BasicBlock)ctor.newInstance(fileName, strict, body.getVariableDeclarations(), body.getFunctionDeclarations());
            entry.setCompiled(block);
            return block;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public String nextClassName(String grist) {
        return this.getConfig().getBasePackage().replace('.', '/') + "/" + grist + this.nextCounterValue();
    }

    private int nextCounterValue() {
        return this.counter.getAndIncrement();
    }
}

