/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.ast.BaseExpression;
import org.dynjs.parser.ast.Expression;
import org.dynjs.parser.ast.FunctionDeclaration;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class ArrayLiteralExpression
extends BaseExpression {
    private final List<Expression> exprs;

    public ArrayLiteralExpression(Position position, List<Expression> exprs) {
        super(position);
        this.exprs = exprs;
    }

    @Override
    public List<FunctionDeclaration> getFunctionDeclarations() {
        ArrayList<FunctionDeclaration> decls = new ArrayList<FunctionDeclaration>();
        for (Expression each : this.exprs) {
            if (each == null) continue;
            decls.addAll(each.getFunctionDeclarations());
        }
        return decls;
    }

    public List<Expression> getExprs() {
        return this.exprs;
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }

    @Override
    public int getSizeMetric() {
        int size = 0;
        for (Expression each : this.exprs) {
            if (each == null) continue;
            size += each.getSizeMetric();
        }
        return size + 3;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        boolean first = true;
        for (Expression each : this.exprs) {
            if (!first) {
                buf.append(", ");
            }
            if (each == null) continue;
            buf.append(each.toString());
        }
        buf.append("]");
        return buf.toString();
    }
}

