/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.ast.AbstractExpression;
import org.dynjs.parser.ast.FunctionDescriptor;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class FunctionExpression
extends AbstractExpression {
    private FunctionDescriptor descriptor;

    public FunctionExpression(FunctionDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public Position getPosition() {
        return this.descriptor.getPosition();
    }

    public FunctionDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int getSizeMetric() {
        return this.descriptor.getSizeMetric() + 15;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("function").append(this.descriptor.getIdentifier() == null ? "" : " " + this.descriptor.getIdentifier()).append("(");
        String[] params = this.descriptor.getFormalParameterNames();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(params[i]);
        }
        buf.append(") {");
        buf.append(this.descriptor.getBlock().toIndentedString("  "));
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }
}

