/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.ast.BaseStatement;
import org.dynjs.parser.ast.CaseClause;
import org.dynjs.parser.ast.Expression;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class SwitchStatement
extends BaseStatement {
    private Expression expr;
    private List<CaseClause> caseClauses;

    public SwitchStatement(Position position, Expression expr, List<CaseClause> caseClauses) {
        super(position);
        this.expr = expr;
        this.caseClauses = caseClauses;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public List<CaseClause> getCaseClauses() {
        return this.caseClauses;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        ArrayList<VariableDeclaration> decls = new ArrayList<VariableDeclaration>();
        for (CaseClause each : this.caseClauses) {
            decls.addAll(each.getVariableDeclarations());
        }
        return decls;
    }

    @Override
    public int getSizeMetric() {
        int size = this.expr.getSizeMetric();
        for (CaseClause each : this.caseClauses) {
            size += each.getSizeMetric();
        }
        return size + 11;
    }

    @Override
    public String toIndentedString(String indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(indent).append("switch (").append(this.expr.toString()).append(" ) {\n");
        for (CaseClause each : this.caseClauses) {
            buf.append(each.toIndentedString("  " + indent));
        }
        buf.append(indent).append("}");
        return buf.toString();
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }
}

