/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.ast;

import java.util.List;
import org.dynjs.parser.CodeVisitor;
import org.dynjs.parser.Statement;
import org.dynjs.parser.ast.BaseStatement;
import org.dynjs.parser.ast.Expression;
import org.dynjs.parser.ast.VariableDeclaration;
import org.dynjs.parser.js.Position;
import org.dynjs.runtime.ExecutionContext;

public class WithStatement
extends BaseStatement {
    private final Expression expr;
    private final Statement block;

    public WithStatement(Position position, Expression expr, Statement block) {
        super(position);
        this.expr = expr;
        this.block = block;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public Statement getBlock() {
        return this.block;
    }

    @Override
    public int getSizeMetric() {
        return this.expr.getSizeMetric() + 3;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        return this.block.getVariableDeclarations();
    }

    @Override
    public String toIndentedString(String indent) {
        StringBuilder buf = new StringBuilder();
        buf.append(indent).append("with (").append(this.expr.toString()).append(") {\n");
        buf.append(this.block.toIndentedString(indent + "  "));
        buf.append(indent).append("}");
        return buf.toString();
    }

    @Override
    public void accept(ExecutionContext context, CodeVisitor visitor, boolean strict) {
        visitor.visit(context, this, strict);
    }
}

