/*
 * Decompiled with CFR 0.152.
 */
package org.dynjs.parser.js;

import java.io.IOException;
import java.io.Reader;
import org.dynjs.parser.js.CharStream;

public class CircularCharBuffer
implements CharStream {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private Reader in;
    private char[] buf;
    private int readPos = 0;
    private int writePos = 0;
    private int available = 0;
    private boolean eof = false;

    public CircularCharBuffer(Reader in) throws IOException {
        this(in, 2048);
    }

    public CircularCharBuffer(Reader in, int bufferSize) throws IOException {
        this.in = in;
        this.buf = new char[bufferSize];
        this.fill();
    }

    public int available() {
        return this.available;
    }

    private void fill() throws IOException {
        int len = 0;
        if (this.writePos == this.readPos && this.available > 0) {
            return;
        }
        len = this.writePos >= this.readPos ? this.buf.length - this.writePos : this.readPos - this.writePos;
        int amountRead = this.in.read(this.buf, this.writePos, len);
        if (amountRead < 0) {
            this.eof = true;
            return;
        }
        this.available += amountRead;
        this.writePos = (this.writePos + amountRead) % this.buf.length;
    }

    @Override
    public int peek() throws IOException {
        return this.peek(1);
    }

    @Override
    public int peek(int pos) throws IOException {
        if (this.available() < pos) {
            this.fill();
        }
        if (this.available() < pos) {
            return -1;
        }
        int c = (this.readPos + pos - 1) % this.buf.length;
        return this.buf[c];
    }

    @Override
    public int consume() throws IOException {
        int c = this.peek();
        ++this.readPos;
        --this.available;
        if (this.readPos == this.buf.length) {
            this.readPos = 0;
        }
        return c;
    }
}

